/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.activation;

import com.ericsson.em.m3if.operations.annotations.SensitiveValue;
import com.ericsson.em.m3if.v1_0.common.ActivationCredential;
import com.ericsson.em.validators.IsBankDomain;
import com.ericsson.em.validators.IsCurrencyCode;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsSecretString;
import com.ericsson.em.validators.IsSingleWordString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="activationrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"identity", "credentials", "securityQuestionAnswer", "bankDomainName", "currency", "invitationToken"})
public class ActivationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @NotNull
    @IsIdentity
    @XmlElement(name="identity", required=true)
    private String identity;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="credentials")
    @XmlElement(name="credential", type=ActivationCredential.class)
    private List<ActivationCredential> credentials = new LinkedList<ActivationCredential>();
    @Length(max=512)
    @IsSecretString
    @SensitiveValue
    @XmlElement(name="securityquestionanswer")
    private String securityQuestionAnswer;
    @IsBankDomain
    @XmlElement(name="bankdomainname")
    private String bankDomainName;
    @IsCurrencyCode
    @XmlElement(name="currency")
    private String currency;
    @Length(max=32)
    @IsSingleWordString
    @XmlElement(name="invitationtoken")
    private String invitationToken;

    public String getInvitationToken() {
        return this.invitationToken;
    }

    public void setInvitationToken(String invitationToken) {
        this.invitationToken = invitationToken;
    }

    public ActivationRequest(String identity) {
        this.identity = identity;
    }

    public ActivationRequest(String identity, String bankDomainName, String currency) {
        this.identity = identity;
        this.bankDomainName = bankDomainName;
        this.currency = currency;
    }

    public ActivationRequest() {
        this.identity = null;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public List<ActivationCredential> getCredentials() {
        return this.credentials;
    }

    public void addCredential(ActivationCredential activationCredential) {
        this.credentials.add(activationCredential);
    }

    public void setCredentials(List<ActivationCredential> credentials) {
        this.credentials = credentials;
    }

    public void setCredential(ActivationCredential credential) {
        this.credentials.add(credential);
    }

    public String getSecurityQuestionAnswer() {
        return this.securityQuestionAnswer;
    }

    public void setSecurityQuestionAnswer(String securityQuestionAnswer) {
        this.securityQuestionAnswer = securityQuestionAnswer;
    }

    public String getBankDomainName() {
        return this.bankDomainName;
    }

    public void setBankDomainName(String bankDomainName) {
        this.bankDomainName = bankDomainName;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Currency getCurrencyInstance() {
        return this.currency != null ? Currency.getInstance(this.currency) : null;
    }
}

