/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.updateaccountholderaddress;

import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import iso.std.iso._20022.tech.xsd.PostalAddress3;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="updateaccountholderaddressrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"identity", "addresses", "reason"})
public class UpdateAccountHolderAddressRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @XmlElement(name="identity")
    @IsIdentity
    private String identity;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="addresses")
    @XmlElements(value={@XmlElement(name="address", type=PostalAddress3.class)})
    private List<PostalAddress3> addresses;
    @Length(max=512)
    @IsMultilineRestrictedString
    @XmlElement(name="reason")
    private String reason;

    public UpdateAccountHolderAddressRequest() {
    }

    public UpdateAccountHolderAddressRequest(String identity) {
        this.identity = identity;
    }

    public UpdateAccountHolderAddressRequest(String identity, List<PostalAddress3> addresses) {
        this.identity = identity;
        this.addresses = addresses;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public List<PostalAddress3> getAddresses() {
        if (this.addresses == null) {
            return Collections.emptyList();
        }
        return this.addresses;
    }

    public void setAddresses(List<PostalAddress3> addresses) {
        this.addresses = addresses;
    }

    public boolean containsAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean hasReason() {
        return this.reason != null;
    }
}

