/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.updateaccountholderidentification;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.OtpValue;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import iso.std.iso._20022.tech.xsd.GenericIdentification9;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="updateaccountholderidentificationrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"identity", "identifications", "reason", "otp", "quoteId"})
public class UpdateAccountHolderIdentificationRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @XmlElement(name="identity")
    @IsIdentity
    private String identity;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="identifications")
    @XmlElements(value={@XmlElement(name="identification", type=GenericIdentification9.class)})
    private List<GenericIdentification9> identifications;
    @Length(max=512)
    @IsMultilineRestrictedString
    @XmlElement(name="reason")
    private String reason;
    @Valid
    @XmlElement(name="otp", type=OtpValue.class)
    private OtpValue otp;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;
    @XmlTransient
    protected FinancialTransactionId financialTransactionId;
    @XmlTransient
    protected Boolean wasRatingManagedByApproval = false;

    public UpdateAccountHolderIdentificationRequest() {
    }

    public UpdateAccountHolderIdentificationRequest(String identity) {
        this.identity = identity;
    }

    public UpdateAccountHolderIdentificationRequest(String identity, List<GenericIdentification9> identifications) {
        this.identity = identity;
        this.identifications = identifications;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public List<GenericIdentification9> getIdentifications() {
        if (this.identifications == null) {
            return Collections.emptyList();
        }
        return this.identifications;
    }

    public void setIdentifications(List<GenericIdentification9> identifications) {
        this.identifications = identifications;
    }

    public boolean containsIdentifications() {
        return this.identifications != null && !this.identifications.isEmpty();
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public OtpValue getOtp() {
        return this.otp;
    }

    public void setOtp(OtpValue otp) {
        this.otp = otp;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Boolean getWasRatingManagedByApproval() {
        return this.wasRatingManagedByApproval;
    }
}

