/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_1.setaccountholderratingparameters;

import com.ericsson.em.m3if.provisioning.v1_0.common.RatingParameterName;
import com.ericsson.em.m3if.provisioning.v1_0.common.RatingParameterValue;
import com.ericsson.em.m3if.provisioning.v1_1.common.RatingParameter;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.ReasonValue;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_1", name="setaccountholderratingparametersrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_1", name="", propOrder={"identity", "reason", "ratingParametersList"})
public class SetAccountHolderRatingParametersRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="identity", type=IdentityValue.class)
    private IdentityValue identity;
    @Valid
    @NotNull
    @XmlElement(name="reason", type=ReasonValue.class, required=true)
    private ReasonValue reason;
    @Valid
    @NotNull
    @NoNullElements
    @Size(max=50)
    @XmlElementWrapper(name="ratingparameterslist", required=true)
    @XmlElements(value={@XmlElement(name="ratingparameter", type=RatingParameter.class)})
    private @Valid @NotNull @Size(max=50) List<RatingParameter> ratingParametersList = new ArrayList<RatingParameter>();

    public List<RatingParameter> getRatingParametersList() {
        return this.ratingParametersList;
    }

    public void setRatingParametersList(List<RatingParameter> ratingParametersList) {
        this.ratingParametersList = ratingParametersList;
    }

    public IdentityValue getIdentity() {
        return this.identity;
    }

    public void setIdentity(IdentityValue identity) {
        this.identity = identity;
    }

    public ReasonValue getReason() {
        return this.reason;
    }

    public void setReason(ReasonValue reason) {
        this.reason = reason;
    }

    public void setRatingParameter(String name, String value, DateTime expiryTime) {
        if (name != null) {
            Optional<RatingParameter> existing = this.findParameter(name);
            if (value != null && !value.isEmpty()) {
                if (existing.isPresent()) {
                    existing.get().setValue(RatingParameterValue.fromString(value));
                } else {
                    this.ratingParametersList.add(new RatingParameter(RatingParameterName.fromString(name), RatingParameterValue.fromString(value), Iso8601DateTime.fromDateTime(expiryTime)));
                }
            } else {
                this.ratingParametersList.remove(existing.orElse(null));
            }
        }
    }

    public String getRatingParameterValue(String name) {
        if (name != null) {
            return this.findParameter(name).map(parameter -> parameter.getValue().getValueAsString()).orElse(null);
        }
        return null;
    }

    private Optional<RatingParameter> findParameter(String name) {
        return this.ratingParametersList.stream().filter(parameter -> parameter.getName().getValueAsString().equals(name)).findFirst();
    }
}

