/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.externalinstrument;

import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.IsRestrictedString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;

public class AdditionalInformation
implements Serializable {
    @NotNull
    @Size(min=1, max=64)
    @IsRestrictedString
    @XmlElement(name="name", required=true)
    private final @NotNull @Size(min=1, max=64) String name;
    @NotNull
    @Size(min=1, max=128)
    @IsRestrictedString
    @XmlElement(name="value", required=true)
    private final @NotNull @Size(min=1, max=128) String value;
    @Valid
    @NotNull
    private final Iso8601DateTime lastUpdatedTimestamp;

    AdditionalInformation(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Iso8601DateTime getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalInformation that = (AdditionalInformation)o;
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static final class Builder {
        private String name;
        private String value;
        private Iso8601DateTime lastUpdatedTimestamp;

        Builder() {
        }

        public Builder name(String val) {
            this.name = val;
            return this;
        }

        public Builder value(String val) {
            this.value = val;
            return this;
        }

        public Builder lastUpdatedTimestamp(Iso8601DateTime val) {
            this.lastUpdatedTimestamp = val;
            return this;
        }

        public AdditionalInformation build() {
            return Validation.validate(new AdditionalInformation(this));
        }
    }
}

