/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.location;

import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Objects;

public class LocationDataEntry
implements Serializable {
    private static final long serialVersionUID = 1815737640210367584L;
    @Size(max=16)
    @NotEmpty
    private final @Size(max=16) String type;
    @Size(max=32)
    @NotEmpty
    private final @Size(max=32) String name;
    @Size(max=32)
    @NotEmpty
    private final @Size(max=32) String value;

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    LocationDataEntry(Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.value = builder.value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "LocationDataEntry{type='" + this.type + "', name='" + this.name + "', value='" + this.value + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationDataEntry that = (LocationDataEntry)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.value);
    }

    public static final class Builder {
        private String type;
        private String name;
        private String value;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public LocationDataEntry build() {
            return Validation.validate(new LocationDataEntry(this));
        }
    }
}

