/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.profile;

import com.ericsson.em.m3if.rds.v1_0.profile.ProfileTag;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

public class ProfileRecord
implements Serializable {
    private static final long serialVersionUID = 3348525375351132290L;
    @Valid
    private final IdentityValue initiatingUser;
    @NotEmpty
    @Size(max=64)
    private final @Size(max=64) String profileName;
    @Size(max=64)
    private final @Size(max=64) String profileType;
    @NoNullElements
    private final List<ProfileTag> profileTags;
    @Valid
    @NotNull
    private final Iso8601DateTime lastUpdatedTimestamp;

    public IdentityValue getInitiatingUser() {
        return this.initiatingUser;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getProfileType() {
        return this.profileType;
    }

    public List<ProfileTag> getProfileTags() {
        return this.profileTags;
    }

    public Iso8601DateTime getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    ProfileRecord(Builder builder) {
        this.initiatingUser = builder.initiatingUser;
        this.profileName = builder.profileName;
        this.profileType = builder.profileType;
        this.profileTags = builder.profileTags;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentityValue initiatingUser;
        private String profileName;
        private String profileType;
        private List<ProfileTag> profileTags;
        private Iso8601DateTime lastUpdatedTimestamp;

        public Builder initiatingUser(IdentityValue initiatingUser) {
            this.initiatingUser = initiatingUser;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        public Builder profileTags(List<ProfileTag> profileTags) {
            this.profileTags = profileTags;
            return this;
        }

        public Builder lastUpdatedTimestamp(Iso8601DateTime lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public ProfileRecord build() {
            return Validation.validate(new ProfileRecord(this));
        }
    }
}

