/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.ratingparameter;

import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;

public class AccountHolderRatingParameterRecord
implements Serializable {
    private static final long serialVersionUID = -3617397873322945678L;
    @Valid
    @NotNull
    private final Long fkRatingParameterDefinition;
    @NotNull
    @Length(min=1, max=128)
    @IsRestrictedString
    private final String value;

    AccountHolderRatingParameterRecord(String value, Long fkRatingParameterDefinition) {
        this.value = value;
        this.fkRatingParameterDefinition = fkRatingParameterDefinition;
    }

    public static AccountHolderRatingParameterRecord create(String value, Long fkNameId) {
        return Validation.validate(new AccountHolderRatingParameterRecord(value, fkNameId));
    }

    public Long getFkRatingParameterDefinition() {
        return this.fkRatingParameterDefinition;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderRatingParameterRecord that = (AccountHolderRatingParameterRecord)o;
        return this.fkRatingParameterDefinition.equals(that.fkRatingParameterDefinition) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.fkRatingParameterDefinition, this.value);
    }

    public String toString() {
        return "RatingParametersRecord{fkRatingParameterDefinition=" + this.fkRatingParameterDefinition + ", value='" + this.value + "'}";
    }
}

