/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.savings.v1_1.common;

import com.ericsson.em.m3if.bankdomain.v1_0.common.BankDomainName;
import com.ericsson.em.m3if.provisioning.v1_1.common.CompanyInformation;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsPersonalName;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/savings/v1_1/common", name="savingsprovider", propOrder={"id", "providerName", "descriptiveName", "description", "depositFri", "interestFri", "companyInformation", "bankDomainName", "offerBankDomainNames"})
public class SavingsProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id")
    private Long id;
    @Length(max=64)
    @IsUsername
    @XmlElement(name="providername")
    private String providerName;
    @IsPersonalName
    @Length(max=48)
    @XmlElement(name="descriptivename")
    private String descriptiveName;
    @Length(min=1, max=128)
    @IsRestrictedString
    @XmlElement(name="description")
    private String description;
    @NotNull
    @NotEmpty
    @IsFinancialResourceIdentifier
    @XmlElement(name="depositfri", required=true)
    private String depositFri;
    @NotNull
    @NotEmpty
    @IsFinancialResourceIdentifier
    @XmlElement(name="interestfri", required=true)
    private String interestFri;
    @Valid
    @XmlElement(name="companyinformation")
    private CompanyInformation companyInformation;
    @Valid
    @XmlElement(name="bankdomainname")
    private BankDomainName bankDomainName;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="offerbankdomainnames")
    @XmlElements(value={@XmlElement(name="bankdomainname", type=BankDomainName.class)})
    private List<BankDomainName> offerBankDomainNames;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    public void setDescriptiveName(String descriptiveName) {
        this.descriptiveName = descriptiveName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CompanyInformation getCompanyInformation() {
        return this.companyInformation;
    }

    public void setCompanyInformation(CompanyInformation companyInformation) {
        this.companyInformation = companyInformation;
    }

    public BankDomainName getBankDomainName() {
        return this.bankDomainName;
    }

    public void setBankDomainName(BankDomainName bankDomainName) {
        this.bankDomainName = bankDomainName;
    }

    public List<BankDomainName> getOfferBankDomainNames() {
        return this.offerBankDomainNames;
    }

    public void setOfferBankDomainNames(List<BankDomainName> offerBankDomainNames) {
        this.offerBankDomainNames = offerBankDomainNames;
    }

    public String getDepositFri() {
        return this.depositFri;
    }

    public void setDepositFri(String depositFri) {
        this.depositFri = depositFri;
    }

    public String getInterestFri() {
        return this.interestFri;
    }

    public void setInterestFri(String interestFri) {
        this.interestFri = interestFri;
    }
}

