/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_0.backend.preapproval;

import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Currency;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/backend", name="preapprovalrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/backend", name="", propOrder={"fromFRI", "fromFriCurrencyCode", "toFRI", "toFriCurrencyCode", "message"})
@SignedElements(value={"fromfri", "fromfricurrency/code", "tofri", "tofricurrency/code"})
public class PreApprovalRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @Valid
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromfri", required=true)
    private String fromFRI;
    @Valid
    @XmlElement(name="fromfricurrency", required=false)
    private CurrencyCode fromFriCurrencyCode;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="tofri", required=true)
    private String toFRI;
    @Valid
    @XmlElement(name="tofricurrency", required=false)
    private CurrencyCode toFriCurrencyCode;
    @NotNull
    @IsRestrictedString
    @XmlElement(name="message", required=true)
    private String message;

    public PreApprovalRequest() {
    }

    public PreApprovalRequest(String fromFri, String toFri, String message) {
        this(fromFri, null, toFri, null, message);
    }

    public PreApprovalRequest(String fromFri, Currency fromFriCurrency, String toFri, Currency toFriCurrency, String message) {
        this.fromFRI = fromFri;
        this.fromFriCurrencyCode = this.safeCurrencyCode(fromFriCurrency);
        this.toFRI = toFri;
        this.toFriCurrencyCode = this.safeCurrencyCode(toFriCurrency);
        this.message = message;
    }

    public String getFromFRI() {
        return this.fromFRI;
    }

    public void setFromFRI(String fromFRI) {
        this.fromFRI = fromFRI;
    }

    public String getToFRI() {
        return this.toFRI;
    }

    public void setToFRI(String toFRI) {
        this.toFRI = toFRI;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CurrencyCode getFromFriCurrencyCode() {
        return this.fromFriCurrencyCode;
    }

    public void setFromFriCurrencyCode(CurrencyCode fromFriCurrencyCode) {
        this.fromFriCurrencyCode = fromFriCurrencyCode;
    }

    public CurrencyCode getToFriCurrencyCode() {
        return this.toFriCurrencyCode;
    }

    public void setToFriCurrencyCode(CurrencyCode toFriCurrencyCode) {
        this.toFriCurrencyCode = toFriCurrencyCode;
    }

    private CurrencyCode safeCurrencyCode(Currency fromFriCurrency) {
        return fromFriCurrency == null ? null : new CurrencyCode(fromFriCurrency.getCurrencyCode());
    }
}

