/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_0.common;

import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsNumericString;
import com.ericsson.em.validators.IsSurname;
import jakarta.validation.Valid;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/common", name="paymenthistoryentry", propOrder={"financialTransactionId", "transactionStatus", "transferType", "startDate", "fromAccountHolder", "fromFirstName", "fromLastName", "toAccountHolder", "toFirstName", "toLastName", "amount"})
public class PaymentHistoryEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsNumericString
    @XmlElement(name="financialtransactionid")
    private String financialTransactionId = null;
    @XmlElement(name="transactionstatus")
    private FinancialTransactionStatus transactionStatus;
    @Valid
    @XmlElement(name="transfertype")
    private TransferType transferType;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="startdate")
    private DateTimeValue startDate;
    @IsIdentity
    @XmlElement(name="fromaccountholder")
    private String fromAccountHolder;
    @IsFirstname
    @XmlElement(name="fromfirstname")
    private String fromFirstName;
    @IsSurname
    @XmlElement(name="fromlastname")
    private String fromLastName;
    @IsIdentity
    @XmlElement(name="toaccountholder")
    private String toAccountHolder;
    @IsFirstname
    @XmlElement(name="tofirstname")
    private String toFirstName;
    @IsSurname
    @XmlElement(name="tolastname")
    private String toLastName;
    @Valid
    @XmlElement(name="amount")
    @IsPositiveAmount
    private MoneyDetails amount;

    public String getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(String financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public FinancialTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public DateTime getStartDate() {
        return this.startDate != null ? this.startDate.getTimestampAsDate() : null;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate != null ? new DateTimeValue(startDate) : null;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public String getFromAccountHolder() {
        return this.fromAccountHolder;
    }

    public void setFromAccountHolder(String fromAccountHolder) {
        this.fromAccountHolder = fromAccountHolder;
    }

    public String getFromFirstName() {
        return this.fromFirstName;
    }

    public void setFromFirstName(String fromFirstName) {
        this.fromFirstName = fromFirstName;
    }

    public String getFromLastName() {
        return this.fromLastName;
    }

    public void setFromLastName(String fromLastName) {
        this.fromLastName = fromLastName;
    }

    public String getToAccountHolder() {
        return this.toAccountHolder;
    }

    public void setToAccountHolder(String toAccountHolder) {
        this.toAccountHolder = toAccountHolder;
    }

    public String getToFirstName() {
        return this.toFirstName;
    }

    public void setToFirstName(String toFirstName) {
        this.toFirstName = toFirstName;
    }

    public String getToLastName() {
        return this.toLastName;
    }

    public void setToLastName(String toLastName) {
        this.toLastName = toLastName;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }
}

