/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_0.frontend.getpaymenthistory;

import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/frontend", name="getpaymenthistoryrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/frontend", name="", propOrder={"identity", "paymentReference", "numOfTransactions", "indexOffset", "dateFrom", "dateTo"})
public class GetPaymentHistoryRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAXLIMIT = 10;
    @Valid
    @XmlElement(name="identity")
    private IdentityValue identity;
    @NotNull
    @Length(min=1, max=256)
    @IsRestrictedString
    @XmlElement(name="paymentreference", required=true)
    private String paymentReference;
    @Min(value=1L)
    @Max(value=10L)
    @NotNull
    @XmlElement(name="numoftransactions", defaultValue="10")
    private @Min(value=1L) @Max(value=10L) @NotNull int numOfTransactions = 10;
    @XmlElement(name="indexoffset", defaultValue="0")
    private int indexOffset = 0;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="datefrom")
    private DateTimeValue dateFrom;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="dateto")
    private DateTimeValue dateTo;

    public IdentityValue getIdentity() {
        return this.identity;
    }

    public void setIdentity(IdentityValue identity) {
        this.identity = identity;
    }

    public String getPaymentReference() {
        return this.paymentReference;
    }

    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    public DateTime getDateFrom() {
        return this.dateFrom != null ? this.dateFrom.getTimestampAsDate() : null;
    }

    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = dateFrom != null ? new DateTimeValue(dateFrom) : null;
    }

    public DateTime getDateTo() {
        return this.dateTo != null ? this.dateTo.getTimestampAsDate() : null;
    }

    public void setDateTo(DateTime dateTo) {
        this.dateTo = dateTo != null ? new DateTimeValue(dateTo) : null;
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public void setNumOfTransactions(int numOfTransactions) {
        this.numOfTransactions = numOfTransactions;
    }

    @XmlTransient
    public int getNumOfTransactions() {
        return this.numOfTransactions;
    }
}

