/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_0.frontend.payment;

import com.ericsson.em.m3if.coupons.v1_0.common.Coupon;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ScheduledTransactionDate;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIntegerStringWithinRange;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/frontend", name="paymentrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_0/frontend", name="", propOrder={"referenceId", "sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "scheduled", "extension", "quoteId", "coupon", "maxNumberOfRetries"})
@Deprecated
public class PaymentRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @Length(max=64)
    @IsExternalReferenceString
    @XmlElement(name="referenceid")
    private String referenceId;
    @IsFinancialResourceIdentifier
    @XmlElement(name="sendingfri")
    private String sendingFRI;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="receivingfri", required=true)
    private String receivingFRI;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote")
    private String senderNote;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage")
    private String receiverMessage;
    @Valid
    @XmlElement(name="scheduled", type=ScheduledTransactionDate.class)
    private ScheduledTransactionDate scheduled;
    @Valid
    @XmlElement(name="extension")
    private ExtensionType extension;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="coupon", type=Coupon.class)
    private Coupon coupon;
    @IsIntegerStringWithinRange(min=0)
    @XmlElement(name="maxnumberofretries", required=false)
    private String maxNumberOfRetries;

    public PaymentRequest() {
    }

    public PaymentRequest(String referenceId, String sendingFRI, String receivingFRI, MoneyDetails amount, String senderNote, String receiverMessage, ExtensionType extension) {
        this.setReferenceId(referenceId);
        this.setSendingFRI(sendingFRI);
        this.setReceivingFRI(receivingFRI);
        this.setAmount(amount);
        this.setSenderNote(senderNote);
        this.setReceiverMessage(receiverMessage);
        this.setExtension(extension);
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(String sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public String getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(String receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    public ScheduledTransactionDate getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(ScheduledTransactionDate scheduled) {
        this.scheduled = scheduled;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Coupon getCoupon() {
        return this.coupon;
    }

    public void setCoupon(Coupon coupon) {
        this.coupon = coupon;
    }

    public String getMaxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }

    public void setMaxNumberOfRetries(String maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
    }
}

