/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_2.frontend.getserviceproviderdetails;

import com.ericsson.em.m3if.v1_0.common.ProviderType;
import com.ericsson.em.validators.IsBankDomain;
import com.ericsson.em.validators.IsProfileName;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_2/frontend", name="getserviceproviderdetailsresponse")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_2/frontend", name="", propOrder={"serviceProviderUserId", "profileName", "bankDomainName", "descriptiveName", "linkAccount", "serviceProviderTypes"})
public class GetServiceProviderDetailsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotBlank
    @NotNull
    @IsUsername
    @Length(max=64)
    @XmlElement(name="serviceprovideruserid", required=true)
    private String serviceProviderUserId;
    @NotNull
    @IsProfileName
    @XmlElement(name="profilename", required=true)
    private String profileName;
    @NotNull
    @IsBankDomain
    @XmlElement(name="bankdomainname", required=true)
    private String bankDomainName;
    @IsRestrictedString
    @Length(max=48)
    @XmlElement(name="descriptivename", required=false)
    private String descriptiveName;
    @XmlElement(name="linkaccount", required=false, defaultValue="true")
    private Boolean linkAccount = true;
    @Valid
    @NotNull
    @NoNullElements
    @XmlElementWrapper(name="serviceprovidertypes", required=true)
    @XmlElements(value={@XmlElement(name="serviceprovidertype", type=ProviderType.class, required=false)})
    private List<ProviderType> serviceProviderTypes = new ArrayList<ProviderType>();

    public GetServiceProviderDetailsResponse() {
    }

    public GetServiceProviderDetailsResponse(String serviceProviderUserId, String profileName, String bankDomainName, String descriptiveName, Boolean linkAccount) {
        this.serviceProviderUserId = serviceProviderUserId;
        this.profileName = profileName;
        this.bankDomainName = bankDomainName;
        this.descriptiveName = descriptiveName;
        this.linkAccount = linkAccount;
    }

    public String getServiceProviderUserId() {
        return this.serviceProviderUserId;
    }

    public void setServiceProviderUserId(String serviceProviderUserId) {
        this.serviceProviderUserId = serviceProviderUserId;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getBankDomainName() {
        return this.bankDomainName;
    }

    public void setBankDomainName(String bankDomainName) {
        this.bankDomainName = bankDomainName;
    }

    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    public void setDescriptiveName(String descriptiveName) {
        this.descriptiveName = descriptiveName;
    }

    public Boolean getLinkAccount() {
        return this.linkAccount;
    }

    public void setLinkAccount(Boolean linkAccount) {
        this.linkAccount = linkAccount;
    }

    public List<ProviderType> getServiceProviderTypes() {
        return this.serviceProviderTypes;
    }

    public void setServiceProviderTypes(List<ProviderType> serviceProviderTypes) {
        this.serviceProviderTypes = serviceProviderTypes;
    }

    public void addServiceProviderType(ProviderType serviceProviderType) {
        this.serviceProviderTypes.add(serviceProviderType);
    }
}

