/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.v1_0.common.SettlementStatus;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsFilesystemPath;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.IsUsername;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0/common", name="settlementdetails", propOrder={"id", "status", "callerIdentifier", "fileName", "openingBalance", "closingBalance", "failureReason", "bookingDateTime", "lastUpdateDateTime", "numberOfPendingWithdrawals", "numberOfSuccessfulWithdrawals", "numberOfFailedWithdrawals", "numberOfPendingDeposits", "numberOfSuspendedDeposits", "numberOfSuccessfulDeposits", "numberOfFailedDeposits", "numberOfPendingReverseDeposits", "numberOfSuccessfulReverseDeposits", "numberOfFailedReverseDeposits"})
public class SettlementDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @XmlElement(name="id", required=true)
    private Long id;
    @XmlElement(name="status")
    private SettlementStatus status;
    @IsUsername
    @XmlElement(name="calleridentifier")
    private String callerIdentifier;
    @IsFilesystemPath
    @XmlElement(name="settlementfilename")
    private String fileName;
    @Valid
    @XmlElement(name="openingbalance")
    @IsPositiveAmount
    private MoneyDetails openingBalance;
    @Valid
    @XmlElement(name="closingbalance")
    @IsPositiveAmount
    private MoneyDetails closingBalance;
    @IsMultiWordString
    @XmlElement(name="failurereason")
    private String failureReason;
    @XmlElement(name="bookingdatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date bookingDateTime;
    @XmlElement(name="lastupdatedatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date lastUpdateDateTime;
    @XmlElement(name="numberofpendingwithdrawals")
    private int numberOfPendingWithdrawals;
    @XmlElement(name="numberofsuccessfulwithdrawals")
    private int numberOfSuccessfulWithdrawals;
    @XmlElement(name="numberoffailedwithdrawals")
    private int numberOfFailedWithdrawals;
    @XmlElement(name="numberofpendingdeposits")
    private int numberOfPendingDeposits;
    @XmlElement(name="numberofsuspendeddeposits")
    private int numberOfSuspendedDeposits;
    @XmlElement(name="numberofsuccessfuldeposits")
    private int numberOfSuccessfulDeposits;
    @XmlElement(name="numberoffaileddeposits")
    private int numberOfFailedDeposits;
    @XmlElement(name="numberofpendingreversedeposits")
    private int numberOfPendingReverseDeposits;
    @XmlElement(name="numberofsuccessfulreversedeposits")
    private int numberOfSuccessfulReverseDeposits;
    @XmlElement(name="numberoffailedreversedeposits")
    private int numberOfFailedReverseDeposits;

    public Long getId() {
        return this.id;
    }

    public void setId(Long ID2) {
        this.id = ID2;
    }

    public SettlementStatus getStatus() {
        return this.status;
    }

    public void setStatus(SettlementStatus status) {
        this.status = status;
    }

    public String getCallerIdentifier() {
        return this.callerIdentifier;
    }

    public void setCallerIdentifier(String callerIdentifier) {
        this.callerIdentifier = callerIdentifier;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public MoneyDetails getOpeningBalance() {
        return this.openingBalance;
    }

    public void setOpeningBalance(MoneyDetails openingBalance) {
        this.openingBalance = openingBalance;
    }

    public MoneyDetails getClosingBalance() {
        return this.closingBalance;
    }

    public void setClosingBalance(MoneyDetails closingBalance) {
        this.closingBalance = closingBalance;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public DateTime getBookingDateTime() {
        return DateHelper.fromDate(this.bookingDateTime);
    }

    public void setBookingDateTime(DateTime bookingDateTime) {
        this.bookingDateTime = DateHelper.toDate(bookingDateTime);
    }

    public DateTime getLastUpdateDateTime() {
        return DateHelper.fromDate(this.lastUpdateDateTime);
    }

    public void setLastUpdateDateTime(DateTime lastUpdateDateTime) {
        this.lastUpdateDateTime = DateHelper.toDate(lastUpdateDateTime);
    }

    public int getNumberOfPendingWithdrawals() {
        return this.numberOfPendingWithdrawals;
    }

    public void setNumberOfPendingWithdrawals(int numberOfPendingWithdrawals) {
        this.numberOfPendingWithdrawals = numberOfPendingWithdrawals;
    }

    public int getNumberOfSuccessfulWithdrawals() {
        return this.numberOfSuccessfulWithdrawals;
    }

    public void setNumberOfSuccessfulWithdrawals(int numberOfSuccessfulWithdrawals) {
        this.numberOfSuccessfulWithdrawals = numberOfSuccessfulWithdrawals;
    }

    public int getNumberOfFailedWithdrawals() {
        return this.numberOfFailedWithdrawals;
    }

    public void setNumberOfFailedWithdrawals(int numberOfFailedWithdrawals) {
        this.numberOfFailedWithdrawals = numberOfFailedWithdrawals;
    }

    public int getNumberOfPendingDeposits() {
        return this.numberOfPendingDeposits;
    }

    public void setNumberOfPendingDeposits(int numberOfPendingDeposits) {
        this.numberOfPendingDeposits = numberOfPendingDeposits;
    }

    public int getNumberOfSuspendedDeposits() {
        return this.numberOfSuspendedDeposits;
    }

    public void setNumberOfSuspendedDeposits(int numberOfSuspendedDeposits) {
        this.numberOfSuspendedDeposits = numberOfSuspendedDeposits;
    }

    public int getNumberOfSuccessfulDeposits() {
        return this.numberOfSuccessfulDeposits;
    }

    public void setNumberOfSuccessfulDeposits(int numberOfSuccessfulDeposits) {
        this.numberOfSuccessfulDeposits = numberOfSuccessfulDeposits;
    }

    public int getNumberOfFailedDeposits() {
        return this.numberOfFailedDeposits;
    }

    public void setNumberOfFailedDeposits(int numberOfFailedDeposits) {
        this.numberOfFailedDeposits = numberOfFailedDeposits;
    }

    public int getNumberOfPendingReverseDeposits() {
        return this.numberOfPendingReverseDeposits;
    }

    public void setNumberOfPendingReverseDeposits(int numberOfPendingReverseDeposits) {
        this.numberOfPendingReverseDeposits = numberOfPendingReverseDeposits;
    }

    public int getNumberOfSuccessfulReverseDeposits() {
        return this.numberOfSuccessfulReverseDeposits;
    }

    public void setNumberOfSuccessfulReverseDeposits(int numberOfSuccessfulReverseDeposits) {
        this.numberOfSuccessfulReverseDeposits = numberOfSuccessfulReverseDeposits;
    }

    public int getNumberOfFailedReverseDeposits() {
        return this.numberOfFailedReverseDeposits;
    }

    public void setNumberOfFailedReverseDeposits(int numberOfFailedReverseDeposits) {
        this.numberOfFailedReverseDeposits = numberOfFailedReverseDeposits;
    }
}

