/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.manualbankinstructioncompleted;

import com.ericsson.em.m3if.operations.approvals.ExpiredApprovalAware;
import com.ericsson.em.m3if.settlement.v1_0.common.CommandType;
import com.ericsson.em.m3if.v1_0.common.ReasonValue;
import com.ericsson.em.m3if.v1_0.common.TransactionId;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="manualbankinstructioncompletedrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="", propOrder={"transactionId", "command", "bankTransactionId", "reason"})
public class ManualBankInstructionCompletedRequest
implements Serializable,
ExpiredApprovalAware {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="transactionid", type=TransactionId.class, required=true)
    private TransactionId transactionId;
    @NotNull
    @Valid
    @XmlElement(name="command", type=CommandType.class, required=true)
    private CommandType command;
    @Length(max=100)
    @IsExternalTransactionIdString
    @XmlElement(name="banktransactionid", required=false)
    private String bankTransactionId;
    @Valid
    @XmlElement(name="reason", type=ReasonValue.class, required=false)
    private ReasonValue reason;

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(TransactionId transactionId) {
        this.transactionId = transactionId;
    }

    public CommandType getCommand() {
        return this.command;
    }

    public void setCommand(CommandType command) {
        this.command = command;
    }

    public String getBankTransactionId() {
        return this.bankTransactionId;
    }

    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    public ReasonValue getReason() {
        return this.reason;
    }

    public void setReason(ReasonValue reason) {
        this.reason = reason;
    }

    @Override
    public Optional<String> getSendingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getReceivingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getSupplementaryData() {
        String transactionMessage = this.bankTransactionId == null ? ", No bank transaction id provided" : ", Bank transaction id: " + this.bankTransactionId;
        return Optional.of("Transaction id: " + this.transactionId.getValue() + transactionMessage);
    }
}

