/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.paymentinstructionresponse;

import com.ericsson.em.m3if.operations.annotations.IdentityTraceAction;
import com.ericsson.em.m3if.operations.annotations.IdentityTraceAsynchronousHint;
import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.v2_0.common.PaymentInstructionResult;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsLongString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@IdentityTraceAsynchronousHint(action=IdentityTraceAction.LOG, field="paymentInstructionId", grouping="paymentinstruction")
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="paymentinstructionresponserequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="", propOrder={"status", "paymentInstructionId", "bankTransactionId", "transactionTimeStamp", "bookingTimeStamp", "amount"})
@SignedElements(value={"status", "paymentinstructionid", "banktransactionid", "amount/amount", "amount/currency"})
public class PaymentInstructionResponseRequest {
    @XmlAttribute
    public static final String version = "1.0";
    @XmlElement(name="status", required=true)
    private PaymentInstructionResult status;
    @NotBlank
    @Length(max=32)
    @IsLongString(allowNegativeValue=false)
    @XmlElement(name="paymentinstructionid", required=true)
    private String paymentInstructionId;
    @NotBlank
    @Length(max=100)
    @IsExternalTransactionIdString
    @XmlElement(name="banktransactionid", required=true)
    private String bankTransactionId;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="transactiontimestamp", required=true)
    private DateTimeValue transactionTimeStamp;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="bookingtimestamp", required=true)
    private DateTimeValue bookingTimeStamp;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;

    public PaymentInstructionResponseRequest() {
    }

    public PaymentInstructionResponseRequest(String paymentInstructionId, String bankTransactionId) {
        this.status = PaymentInstructionResult.FAILED;
        this.paymentInstructionId = paymentInstructionId;
        this.bankTransactionId = bankTransactionId;
    }

    public PaymentInstructionResponseRequest(String paymentInstructionId, String bankTransactionId, DateTimeValue transactionTimeStamp, DateTimeValue bookingTimeStamp, MoneyDetails amount) {
        this.status = PaymentInstructionResult.SUCCESS;
        this.paymentInstructionId = paymentInstructionId;
        this.bankTransactionId = bankTransactionId;
        this.transactionTimeStamp = transactionTimeStamp;
        this.bookingTimeStamp = bookingTimeStamp;
        this.amount = amount;
    }

    public PaymentInstructionResult getStatus() {
        return this.status;
    }

    public void setStatus(PaymentInstructionResult status) {
        this.status = status;
    }

    public String getPaymentInstructionId() {
        return this.paymentInstructionId;
    }

    public void setPaymentInstructionId(String paymentInstructionId) {
        this.paymentInstructionId = paymentInstructionId;
    }

    public String getBankTransactionId() {
        return this.bankTransactionId;
    }

    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    public DateTimeValue getTransactionTimeStamp() {
        return this.transactionTimeStamp;
    }

    public void setTransactionTimeStamp(DateTimeValue transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    public DateTimeValue getBookingTimeStamp() {
        return this.bookingTimeStamp;
    }

    public void setBookingTimeStamp(DateTimeValue bookingTimeStamp) {
        this.bookingTimeStamp = bookingTimeStamp;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }
}

