/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.processsettlementinstructions;

import com.ericsson.em.m3if.settlement.v1_0.processsettlementinstructions.ProcessSettlementInstructionsRequest;
import com.ericsson.em.validators.IsBase64Encoded;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="processsettlementinstructionsapprovalrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="", propOrder={"header", "settlementFileContentType", "settlementInstructions", "digest", "signature"})
public class ProcessSettlementInstructionsApprovalRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="header", required=true)
    private ProcessSettlementInstructionsRequest header;
    @NotNull
    @IsRestrictedString
    @Length(max=256)
    @XmlElement(name="settlementfilecontenttype", required=true)
    private String settlementFileContentType;
    @NotNull
    @IsBase64Encoded
    @XmlElement(name="settlementinstructions", required=true)
    private String settlementInstructions;
    @IsBase64Encoded
    @XmlElement(name="digest")
    private String digest;
    @IsBase64Encoded
    @XmlElement(name="signature")
    private String signature;

    public ProcessSettlementInstructionsApprovalRequest() {
        this.header = null;
        this.setSettlementInstructions(null);
        this.setDigest(null);
        this.setSignature(null);
    }

    public ProcessSettlementInstructionsApprovalRequest(ProcessSettlementInstructionsRequest header, String settlementFileContentType, InputStream settlementInstructions, InputStream digest, InputStream signature) throws IOException {
        this.header = header;
        this.settlementFileContentType = settlementFileContentType;
        this.setSettlementInstructions(this.streamContentToBase64(settlementInstructions));
        this.setDigest(this.streamContentToBase64(digest));
        this.setSignature(this.streamContentToBase64(signature));
    }

    private String streamContentToBase64(InputStream inputStream) throws IOException {
        byte[] content = this.readContentFromStream(inputStream);
        if (content != null && content.length > 0) {
            return DatatypeConverter.printBase64Binary(content);
        }
        return null;
    }

    private byte[] readContentFromStream(InputStream inputStream) throws IOException {
        if (null == inputStream) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(4096);){
            int len;
            byte[] buffer = new byte[4096];
            while ((len = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public ProcessSettlementInstructionsRequest getHeader() {
        return this.header;
    }

    public void setHeader(ProcessSettlementInstructionsRequest header) {
        this.header = header;
    }

    public String getSettlementFileContentType() {
        return this.settlementFileContentType;
    }

    public void setSettlementFileContentType(String settlementFileContentType) {
        this.settlementFileContentType = settlementFileContentType;
    }

    public String getSettlementInstructions() {
        return this.settlementInstructions;
    }

    public void setSettlementInstructions(String settlementInstructions) {
        this.settlementInstructions = settlementInstructions;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public byte[] getSettlementInstructionsBase64Decoded() throws IOException {
        return this.safeCopy(this.settlementInstructions != null ? DatatypeConverter.parseBase64Binary(this.settlementInstructions) : null);
    }

    public byte[] getDigestBase64Decoded() throws IOException {
        return this.safeCopy(this.digest != null ? DatatypeConverter.parseBase64Binary(this.digest) : null);
    }

    public byte[] getSignatureBase64Decoded() throws IOException {
        return this.safeCopy(this.signature != null ? DatatypeConverter.parseBase64Binary(this.signature) : null);
    }

    public String getDigestStringBase64Decoded() throws IOException {
        byte[] asBytes = this.getDigestBase64Decoded();
        return asBytes != null ? new String(asBytes, StandardCharsets.UTF_8) : "";
    }

    public String getSignatureStringBase64Decoded() throws IOException {
        byte[] asBytes = this.getSignatureBase64Decoded();
        return asBytes != null ? new String(asBytes, StandardCharsets.UTF_8) : "";
    }

    private byte[] safeCopy(byte[] byteArrayOrNull) {
        return byteArrayOrNull == null ? null : (byte[])byteArrayOrNull.clone();
    }
}

