/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.reversedeposit;

import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.approvals.ExpiredApprovalAware;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsBankAccount;
import com.ericsson.em.validators.IsBankCode;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="reversedepositrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="", propOrder={"bankCode", "accountNumber", "bankTransactionId", "transactionTimeStamp", "originalBankTransactionId", "originalReceiver", "originalAmount", "message"})
@SignedElements(value={"bankcode", "accountnumber", "banktransactionid", "originalbanktransactionid", "originalreceiver", "originalamount/amount", "originalamount/currency"})
public class ReverseDepositRequest
implements ExpiredApprovalAware {
    @XmlAttribute
    public static final String version = "1.0";
    @IsBankCode
    @XmlElement(name="bankcode", required=false)
    private String bankCode;
    @NotNull
    @IsBankAccount
    @XmlElement(name="accountnumber", required=true)
    private String accountNumber;
    @NotBlank
    @Length(max=100)
    @IsExternalTransactionIdString
    @XmlElement(name="banktransactionid", required=true)
    private String bankTransactionId;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="transactiontimestamp", required=true)
    private DateTimeValue transactionTimeStamp;
    @NotBlank
    @Length(max=100)
    @IsExternalReferenceString
    @XmlElement(name="originalbanktransactionid", required=true)
    private String originalBankTransactionId;
    @NotNull
    @Length(max=100)
    @IsFinancialResourceIdentifier
    @XmlElement(name="originalreceiver", required=true)
    private String originalReceiver;
    @NotNull
    @Valid
    @XmlElement(name="originalamount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails originalAmount;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="message", required=false)
    private String message;

    public ReverseDepositRequest() {
    }

    public ReverseDepositRequest(String accountNumber, String bankTransactionId, DateTimeValue transactionTimeStamp, String originalBankTransactionId, String originalReceiver, MoneyDetails originalAmount, String message) {
        this(null, accountNumber, bankTransactionId, transactionTimeStamp, originalBankTransactionId, originalReceiver, originalAmount, message);
    }

    public ReverseDepositRequest(String accountNumber, String bankTransactionId, DateTimeValue transactionTimeStamp, String originalBankTransactionId, String originalReceiver, MoneyDetails originalAmount) {
        this(null, accountNumber, bankTransactionId, transactionTimeStamp, originalBankTransactionId, originalReceiver, originalAmount, null);
    }

    public ReverseDepositRequest(String bankCode, String accountNumber, String bankTransactionId, DateTimeValue transactionTimeStamp, String originalBankTransactionId, String originalReceiver, MoneyDetails originalAmount) {
        this(bankCode, accountNumber, bankTransactionId, transactionTimeStamp, originalBankTransactionId, originalReceiver, originalAmount, null);
    }

    public ReverseDepositRequest(String bankCode, String accountNumber, String bankTransactionId, DateTimeValue transactionTimeStamp, String originalBankTransactionId, String originalReceiver, MoneyDetails originalAmount, String message) {
        this.bankCode = bankCode;
        this.accountNumber = accountNumber;
        this.bankTransactionId = bankTransactionId;
        this.transactionTimeStamp = transactionTimeStamp;
        this.originalBankTransactionId = originalBankTransactionId;
        this.originalReceiver = originalReceiver;
        this.originalAmount = originalAmount;
        this.message = message;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getBankTransactionId() {
        return this.bankTransactionId;
    }

    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    public DateTimeValue getTransactionTimeStamp() {
        return this.transactionTimeStamp;
    }

    public void setTransactionTimeStamp(DateTimeValue transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    public String getOriginalBankTransactionId() {
        return this.originalBankTransactionId;
    }

    public void setOriginalBankTransactionId(String originalBankTransactionId) {
        this.originalBankTransactionId = originalBankTransactionId;
    }

    public String getOriginalReceiver() {
        return this.originalReceiver;
    }

    public void setOriginalReceiver(String originalReceiver) {
        this.originalReceiver = originalReceiver;
    }

    public MoneyDetails getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(MoneyDetails originalAmount) {
        this.originalAmount = originalAmount;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Optional<String> getSendingFri() {
        return Optional.of(this.getOriginalReceiver());
    }

    @Override
    public Optional<String> getReceivingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getSupplementaryData() {
        return Optional.of("Original bank transaction id: " + this.originalBankTransactionId);
    }
}

