/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v1_0.reversepaymentinstruction;

import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.AccountNumber;
import com.ericsson.em.m3if.v1_0.common.BankCode;
import com.ericsson.em.m3if.v1_0.common.BankTransactionId;
import com.ericsson.em.m3if.v1_0.common.EntityId;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="reversepaymentinstructionrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v1_0", name="", propOrder={"bankCode", "accountNumber", "paymentInstructionId", "bankTransactionId", "transactionTimestamp", "amount"})
@SignedElements(value={"bankcode", "accountnumber", "amount/amount", "amount/currency", "paymentinstructionid", "banktransactionid"})
public class ReversePaymentInstructionRequest {
    @Valid
    @XmlElement(name="bankcode")
    private BankCode bankCode;
    @NotNull
    @Valid
    @XmlElement(name="paymentinstructionid", required=true)
    private EntityId paymentInstructionId;
    @NotNull
    @Valid
    @XmlElement(name="accountnumber", required=true)
    private AccountNumber accountNumber;
    @NotNull
    @Valid
    @XmlElement(name="transactiontimestamp", type=Iso8601DateTime.class, required=true)
    private Iso8601DateTime transactionTimestamp;
    @NotNull
    @IsPositiveAmount
    @Valid
    @XmlElement(name="amount", required=true)
    private MoneyDetails amount;
    @Valid
    @NotNull
    @XmlElement(name="banktransactionid", required=true)
    private BankTransactionId bankTransactionId;

    public ReversePaymentInstructionRequest() {
    }

    public ReversePaymentInstructionRequest(AccountNumber accountNumber, EntityId paymentInstructionId, BankTransactionId bankTransactionId, Iso8601DateTime transactionTimeStamp, MoneyDetails amount) {
        this(null, accountNumber, paymentInstructionId, bankTransactionId, transactionTimeStamp, amount);
    }

    public ReversePaymentInstructionRequest(BankCode bankCode, AccountNumber accountNumber, EntityId paymentInstructionId, BankTransactionId bankTransactionId, Iso8601DateTime transactionTimeStamp, MoneyDetails amount) {
        this.bankCode = bankCode;
        this.accountNumber = accountNumber;
        this.paymentInstructionId = paymentInstructionId;
        this.transactionTimestamp = transactionTimeStamp;
        this.amount = amount;
        this.bankTransactionId = bankTransactionId;
    }

    public BankCode getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(BankCode bankCode) {
        this.bankCode = bankCode;
    }

    public AccountNumber getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(AccountNumber accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Iso8601DateTime getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public void setTransactionTimestamp(Iso8601DateTime transactionTimestamp) {
        this.transactionTimestamp = transactionTimestamp;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public EntityId getPaymentInstructionId() {
        return this.paymentInstructionId;
    }

    public void setPaymentInstructionId(long paymentInstructionId) {
        this.paymentInstructionId = EntityId.from(paymentInstructionId);
    }

    public BankTransactionId getBankTransactionId() {
        return this.bankTransactionId;
    }

    public void setBankTransactionId(BankTransactionId bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = BankTransactionId.fromString(bankTransactionId);
    }
}

