/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v2_0.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.v2_0.common.DepositStatus;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsBankAccount;
import com.ericsson.em.validators.IsBankCode;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsFirstname;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSurname;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v2_0/common", name="settlementdepositdetails", propOrder={"id", "settlementID", "depositStatus", "transactionId", "senderAccountNumber", "senderClearingNumber", "amount", "transactionDateTime", "receiverFirstName", "receiverSurname", "receivingAccountHolderFRI", "receivingAccountFRI", "financialTransactionId", "failureReason", "resolvedReceiverFRI", "resolvedFinancialTransactionId", "correctedBy", "correctionNote", "bookingDateTime", "lastUpdatedDateTime"})
public class SettlementDepositDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @XmlElement(name="id", required=true)
    private Long id;
    @NotNull
    @XmlElement(name="settlementid", required=true)
    private Long settlementID;
    @NotNull
    @XmlElement(name="depositstatus", required=true)
    private DepositStatus depositStatus;
    @IsExternalReferenceString
    @NotBlank
    @XmlElement(name="transactionid")
    private String transactionId;
    @IsBankAccount
    @XmlElement(name="senderaccountnumber")
    private String senderAccountNumber;
    @IsBankCode
    @XmlElement(name="senderclearingnumber")
    private String senderClearingNumber;
    @Valid
    @NotNull
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @XmlElement(name="transactiontimeStamp")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date transactionDateTime;
    @IsFirstname
    @XmlElement(name="receiverfirstname")
    private String receiverFirstName;
    @IsSurname
    @XmlElement(name="receiversurname")
    private String receiverSurname;
    @IsFinancialResourceIdentifier
    @XmlElement(name="receivingaccountholderfri")
    private String receivingAccountHolderFRI;
    @IsFinancialResourceIdentifier
    @XmlElement(name="receivingaccountfri")
    private String receivingAccountFRI;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransactionid")
    private Long financialTransactionId;
    @IsMultiWordString
    @XmlElement(name="failurereason")
    private String failureReason;
    @IsFinancialResourceIdentifier
    @XmlElement(name="resolvedreceiverfri")
    private String resolvedReceiverFRI;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="resolvedfinancialtransactionid")
    private Long resolvedFinancialTransactionId;
    @IsUsername
    @XmlElement(name="correctedby")
    private String correctedBy;
    @IsRestrictedString
    @XmlElement(name="correctionnote")
    private String correctionNote;
    @XmlElement(name="bookingtimestamp")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date bookingDateTime;
    @XmlElement(name="lastupdatedatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date lastUpdatedDateTime;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSettlementID() {
        return this.settlementID;
    }

    public void setSettlementID(Long settlementId) {
        this.settlementID = settlementId;
    }

    public DateTime getBookingDateTime() {
        return DateHelper.fromDate(this.bookingDateTime);
    }

    public void setBookingDateTime(DateTime bookingDateTime) {
        this.bookingDateTime = DateHelper.toDate(bookingDateTime);
    }

    public DateTime getLastUpdatedDateTime() {
        return DateHelper.fromDate(this.lastUpdatedDateTime);
    }

    public void setLastUpdatedDateTime(DateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = DateHelper.toDate(lastUpdatedDateTime);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String bankTransactionId) {
        this.transactionId = bankTransactionId;
    }

    public String getSenderAccountNumber() {
        return this.senderAccountNumber;
    }

    public void setSenderAccountNumber(String senderAccountNumber) {
        this.senderAccountNumber = senderAccountNumber;
    }

    public String getSenderClearingNumber() {
        return this.senderClearingNumber;
    }

    public void setSenderClearingNumber(String senderClearingNumber) {
        this.senderClearingNumber = senderClearingNumber;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public DateTime getTransactionDateTime() {
        return DateHelper.fromDate(this.transactionDateTime);
    }

    public void setTransactionDateTime(DateTime transactionDateTime) {
        this.transactionDateTime = DateHelper.toDate(transactionDateTime);
    }

    public String getReceiverFirstName() {
        return this.receiverFirstName;
    }

    public void setReceiverFirstName(String receiverFirstName) {
        this.receiverFirstName = receiverFirstName;
    }

    public String getReceiverSurname() {
        return this.receiverSurname;
    }

    public void setReceiverSurname(String receiverSurname) {
        this.receiverSurname = receiverSurname;
    }

    public String getReceivingAccountHolderFRI() {
        return this.receivingAccountHolderFRI;
    }

    public void setReceivingAccountHolderFRI(String receivingAccountHolderFRI) {
        this.receivingAccountHolderFRI = receivingAccountHolderFRI;
    }

    public String getReceivingAccountFRI() {
        return this.receivingAccountFRI;
    }

    public void setReceivingAccountFRI(String receivingAccountFRI) {
        this.receivingAccountFRI = receivingAccountFRI;
    }

    public Long getResolvedFinancialTransactionId() {
        return this.resolvedFinancialTransactionId;
    }

    public void setResolvedFinancialTransactionId(Long resolvedFinancialTransactionId) {
        this.resolvedFinancialTransactionId = resolvedFinancialTransactionId;
    }

    public String getResolvedReceiverFRI() {
        return this.resolvedReceiverFRI;
    }

    public void setResolvedReceiverFRI(String resolvedReceiverFRI) {
        this.resolvedReceiverFRI = resolvedReceiverFRI;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public String getCorrectionNote() {
        return this.correctionNote;
    }

    public void setCorrectionNote(String correctionNote) {
        this.correctionNote = correctionNote;
    }

    public String getCorrectedBy() {
        return this.correctedBy;
    }

    public void setCorrectedBy(String correctedBy) {
        this.correctedBy = correctedBy;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public DepositStatus getDepositStatus() {
        return this.depositStatus;
    }

    public void setDepositStatus(DepositStatus depositStatus) {
        this.depositStatus = depositStatus;
    }
}

