/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.settlement.v2_0.depositinstruction;

import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.settlement.any.depositinstruction.IDepositInstructionResponse;
import com.ericsson.em.m3if.settlement.v2_0.common.DepositInstructionResult;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsLongString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/settlement/v2_0", name="depositinstructionresponse")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/settlement/v2_0", name="", propOrder={"status", "depositInstructionId", "bankTransactionId", "transactionTimeStamp", "bookingTimeStamp", "amount"})
@SignedElements(value={"status", "depositinstructionid", "banktransactionid", "amount/amount", "amount/currency"})
public class DepositInstructionResponse
implements IDepositInstructionResponse {
    @XmlElement(name="status", required=true)
    @NotNull
    private DepositInstructionResult status;
    @NotBlank
    @Length(max=32)
    @IsLongString(allowNegativeValue=false)
    @XmlElement(name="depositinstructionid", required=true)
    private String depositInstructionId;
    @NotBlank
    @Length(max=100)
    @IsExternalTransactionIdString
    @XmlElement(name="banktransactionid", required=true)
    private String bankTransactionId;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="transactiontimestamp", required=true)
    private DateTimeValue transactionTimeStamp;
    @Valid
    @NotNull
    @IsDateTimeValue
    @XmlElement(name="bookingtimestamp", required=true)
    private DateTimeValue bookingTimeStamp;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;

    @Override
    public DepositInstructionResult getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(DepositInstructionResult status) {
        this.status = status;
    }

    @Override
    public String getDepositInstructionId() {
        return this.depositInstructionId;
    }

    @Override
    public void setDepositInstructionId(String depositInstructionId) {
        this.depositInstructionId = depositInstructionId;
    }

    @Override
    public String getBankTransactionId() {
        return this.bankTransactionId;
    }

    @Override
    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    @Override
    public DateTimeValue getTransactionTimeStamp() {
        return this.transactionTimeStamp;
    }

    @Override
    public void setTransactionTimeStamp(DateTimeValue transactionTimeStamp) {
        this.transactionTimeStamp = transactionTimeStamp;
    }

    @Override
    public DateTimeValue getBookingTimeStamp() {
        return this.bookingTimeStamp;
    }

    @Override
    public void setBookingTimeStamp(DateTimeValue bookingTimeStamp) {
        this.bookingTimeStamp = bookingTimeStamp;
    }

    @Override
    public MoneyDetails getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    @Override
    public String getBankInstructionId() {
        return this.getDepositInstructionId();
    }

    @Override
    public void setBankInstructionId(String instructionId) {
        this.setDepositInstructionId(instructionId);
    }
}

