/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.SecretValueObject;
import com.ericsson.em.validators.IsASCIIToken;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="apikey")
public class ApiKeyValue
extends SecretValueObject {
    private static final long serialVersionUID = 1L;
    @NotNull
    @NotBlank
    @Length(max=32, min=32)
    @IsASCIIToken
    @XmlValue
    private final String value;

    protected ApiKeyValue() {
        this.value = null;
    }

    private ApiKeyValue(String value) {
        this.value = value;
    }

    public static ApiKeyValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new ApiKeyValue(value);
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiKeyValue other = (ApiKeyValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

