/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsIntegerStringWithinRange;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="creditscorevalue")
public class CreditScoreValue
implements Comparable<CreditScoreValue>,
Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    @NotNull
    @XmlValue
    @IsIntegerStringWithinRange(min=0, max=0x7FFFFFFF)
    private final String creditScoreValue;

    protected CreditScoreValue() {
        this.creditScoreValue = null;
    }

    private CreditScoreValue(String creditScoreValue) {
        this.creditScoreValue = creditScoreValue;
    }

    private CreditScoreValue(Integer creditScoreValue) {
        this.creditScoreValue = creditScoreValue.toString();
    }

    public static CreditScoreValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new CreditScoreValue(value);
    }

    public static CreditScoreValue fromInteger(Integer value) {
        if (value == null) {
            return null;
        }
        return new CreditScoreValue(value);
    }

    public static CreditScoreValue fromLong(Long value) {
        if (value == null) {
            return null;
        }
        if (value > Integer.MAX_VALUE) {
            return null;
        }
        return new CreditScoreValue(value.intValue());
    }

    @Override
    public String getValueAsString() {
        return this.creditScoreValue;
    }

    public static Optional<String> asString(CreditScoreValue creditScoreValue) {
        if (creditScoreValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(creditScoreValue.getValueAsString());
    }

    public String toString() {
        return this.creditScoreValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.creditScoreValue == null ? 0 : this.creditScoreValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreditScoreValue other = (CreditScoreValue)obj;
        return !(this.creditScoreValue == null ? other.creditScoreValue != null : !this.creditScoreValue.equals(other.creditScoreValue));
    }

    @Override
    public int compareTo(CreditScoreValue o) {
        return this.creditScoreValue.compareTo(o.creditScoreValue);
    }
}

