/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.validators.IsSingleWordString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="customdatavalue", propOrder={"key", "value"})
public class CustomDataValue
implements Comparable<CustomDataValue>,
Serializable {
    private static final long serialVersionUID = -4223584100815548063L;
    private static final int MAX_LENGTH_OF_KEY = 128;
    private static final int MIN_LENGTH_OF_KEY = 1;
    private static final int MAX_LENGTH_OF_VALUE = 512;
    private static final int MIN_LENGTH_OF_VALUE = 1;
    @Valid
    @NotNull
    @IsSingleWordString
    @Size(min=1, max=128)
    @XmlElement(name="key", type=String.class, required=true)
    private final @Valid @NotNull @Size(min=1, max=128) String key;
    @Valid
    @NotNull
    @Size(min=1, max=512)
    @XmlElement(name="value", type=String.class, required=true)
    private final @Valid @NotNull @Size(min=1, max=512) String value;

    protected CustomDataValue() {
        this.key = null;
        this.value = null;
    }

    public CustomDataValue(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(CustomDataValue o) {
        if (this.value.compareTo(o.value) == 0) {
            return this.key.compareTo(o.key);
        }
        return this.value.compareTo(o.value);
    }

    public boolean equals(Object o) {
        return o instanceof CustomDataValue && this.compareTo((CustomDataValue)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }
}

