/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="datetime", propOrder={"timestamp"})
public class DateTimeValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @XmlSchemaType(name="dateTime")
    @XmlElement(name="timestamp", required=true)
    private XMLGregorianCalendar timestamp;

    public DateTimeValue() {
    }

    public DateTimeValue(XMLGregorianCalendar timestamp) {
        this.timestamp = timestamp;
    }

    public DateTimeValue(DateTime timestamp) {
        this.setTimestamp(timestamp);
    }

    public XMLGregorianCalendar getTimestamp() {
        return this.timestamp;
    }

    public DateTime getTimestampAsDate() {
        return this.timestamp == null ? null : new DateTime(this.timestamp.toGregorianCalendar());
    }

    public void setTimestamp(XMLGregorianCalendar timestamp) throws ParseException {
        this.timestamp = timestamp;
    }

    private void setTimestamp(DateTime timestamp) {
        if (timestamp != null) {
            try {
                this.timestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(timestamp.toGregorianCalendar());
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return this.timestamp.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeValue other = (DateTimeValue)obj;
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public static Optional<DateTime> asDateTime(DateTimeValue value) {
        return value == null ? Optional.empty() : Optional.ofNullable(value.getTimestampAsDate());
    }

    public static Optional<DateTimeValue> fromDateTime(DateTime value) {
        return value == null ? Optional.empty() : Optional.of(new DateTimeValue(value));
    }
}

