/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.lwac.utilities.xml.ElementNamespaceRemovalTypeAdapter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="extensiontype", propOrder={"any"})
public class ExtensionType
implements Serializable {
    private static final long serialVersionUID = 3L;
    @Valid
    @XmlAnyElement
    @XmlJavaTypeAdapter(value=ElementNamespaceRemovalTypeAdapter.class)
    private List<Element> any = new LinkedList<Element>();
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public ExtensionType() {
    }

    public ExtensionType(List<Element> any) {
        this.any = any;
    }

    @XmlTransient
    public List<Element> getAny() {
        return this.any;
    }

    public void setAny(List<Element> any) {
        this.any = new LinkedList<Element>(any);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.any == null ? 0 : this.any.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionType other = (ExtensionType)obj;
        return !(this.any == null ? other.any != null : !this.any.equals(other.any));
    }

    public String toString() {
        return ExtensionType.toString(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String string = ExtensionType.listToString(this.any);
        out.writeUTF(string);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.any = ExtensionType.listFromString(in.readUTF());
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    public static ExtensionType fromString(String string) {
        if (string == null) {
            return null;
        }
        return new ExtensionType(ExtensionType.listFromString(string));
    }

    public static String toString(ExtensionType extension) {
        if (extension == null) {
            return null;
        }
        return ExtensionType.listToString(extension.any);
    }

    private static String listToString(List<Element> list) {
        try {
            if (list == null || list.isEmpty()) {
                return "";
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element mainElement = document.createElement("any");
            document.appendChild(mainElement);
            for (Element el : list) {
                int i;
                Node imported = document.importNode(el, true);
                NamedNodeMap nnm = imported.getAttributes();
                int size = nnm.getLength();
                String[] removeNames = new String[size];
                for (i = 0; i < size; ++i) {
                    Node n = nnm.item(i);
                    String s = n.getNodeName();
                    if (!s.startsWith("xmlns")) continue;
                    removeNames[i] = n.getNodeName();
                }
                for (i = 0; i < size; ++i) {
                    if (removeNames[i] == null) continue;
                    nnm.removeNamedItem(removeNames[i]);
                }
                mainElement.appendChild(imported);
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (ParserConfigurationException | TransformerException x) {
            throw new RuntimeException(x);
        }
    }

    private static List<Element> listFromString(String data) {
        try {
            if (data == null || data.length() == 0) {
                return Collections.emptyList();
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StringReader reader = new StringReader(data);
            DOMResult domResult = new DOMResult();
            transformer.transform(new StreamSource(reader), domResult);
            Node node = domResult.getNode();
            Node firstChild = node.getFirstChild();
            NodeList nodeList = firstChild.getChildNodes();
            int size = nodeList.getLength();
            ArrayList<Element> elements = new ArrayList<Element>(size);
            for (int i = 0; i < size; ++i) {
                elements.add((Element)nodeList.item(i));
            }
            return elements;
        }
        catch (TransformerException x) {
            throw new RuntimeException(x);
        }
    }

    private void addObject(Node currentNode, JsonObject parent, Map<String, Integer> nodeNamesCountMap) {
        String nodeName = currentNode.getNodeName();
        if (nodeName.startsWith("xmlns") || nodeName.startsWith("#text")) {
            return;
        }
        switch (currentNode.getNodeType()) {
            case 1: {
                JsonElement elementToAdd = this.createElementToAdd(currentNode);
                if (nodeNamesCountMap.get(nodeName) > 1) {
                    JsonArray jsonArray = parent.getAsJsonArray(nodeName) == null ? new JsonArray() : parent.getAsJsonArray(nodeName);
                    jsonArray.add(elementToAdd);
                    parent.add(nodeName, jsonArray);
                    break;
                }
                parent.add(nodeName, elementToAdd);
                break;
            }
            case 3: {
                parent.add(nodeName, new JsonPrimitive(currentNode.getNodeValue()));
                break;
            }
        }
    }

    private void addObjects(NodeList list, JsonObject parent) {
        int i;
        HashMap<String, Integer> nodeNamesCountMap = new HashMap<String, Integer>();
        for (i = 0; i < list.getLength(); ++i) {
            nodeNamesCountMap.merge(list.item(i).getNodeName(), 1, Integer::sum);
        }
        for (i = 0; i < list.getLength(); ++i) {
            this.addObject(list.item(i), parent, nodeNamesCountMap);
        }
    }

    private JsonElement createElementToAdd(Node currentNode) {
        JsonElement elementToAdd;
        if (currentNode.getChildNodes().getLength() == 1 && currentNode.getFirstChild().getNodeType() == 3) {
            elementToAdd = new JsonPrimitive(currentNode.getFirstChild().getNodeValue());
        } else {
            elementToAdd = new JsonObject();
            this.addObjects(currentNode.getChildNodes(), (JsonObject)elementToAdd);
        }
        return elementToAdd;
    }

    public JsonElement serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        HashMap<String, Integer> nodeNamesCountMap = new HashMap<String, Integer>();
        for (Element element : this.any) {
            nodeNamesCountMap.merge(element.getNodeName(), 1, Integer::sum);
        }
        if (this.any != null && !this.any.isEmpty()) {
            try {
                for (Element el : this.getAny()) {
                    this.addObject(el, json, nodeNamesCountMap);
                }
            }
            catch (Exception e) {
                throw new JsonParseException("Cannot serialize Extension", e);
            }
        }
        return json;
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
    }
}

