/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.m3if.v1_0.common.IdentityType;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="identity")
public class IdentityValue
implements Comparable<IdentityValue>,
Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("ID:(.*)/(\\w*)", 2);
    @IsIdentity
    @NotNull
    @NotBlank
    @XmlValue
    private final String identityvalue;

    protected IdentityValue() {
        this.identityvalue = null;
    }

    private IdentityValue(String identity) {
        this.identityvalue = identity;
    }

    public static IdentityValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new IdentityValue(value);
    }

    public static IdentityValue valueOf(String identifier, IdentityType type) {
        return IdentityValue.valueOf(identifier, Optional.ofNullable(type).map(Enum::name).orElse(null));
    }

    public static IdentityValue valueOf(String identifier, String type) {
        if (identifier == null || type == null) {
            return null;
        }
        return IdentityValue.fromString("ID:" + identifier + "/" + type);
    }

    @Override
    public String getValueAsString() {
        return this.identityvalue;
    }

    public String getId() {
        return this.getGroup(PATTERN.matcher(this.identityvalue == null ? "" : this.identityvalue), 1);
    }

    public String getType() {
        return this.getGroup(PATTERN.matcher(this.identityvalue == null ? "" : this.identityvalue), 2);
    }

    private String getGroup(Matcher matcher, int groupNumber) {
        if (matcher.find()) {
            return matcher.group(groupNumber);
        }
        return "";
    }

    public static Optional<String> asString(IdentityValue identity) {
        if (identity == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(identity.getValueAsString());
    }

    public String toString() {
        return this.identityvalue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identityvalue == null ? 0 : this.identityvalue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityValue other = (IdentityValue)obj;
        return !(this.identityvalue == null ? other.identityvalue != null : !this.identityvalue.equals(other.identityvalue));
    }

    @Override
    public int compareTo(IdentityValue o) {
        return this.identityvalue.compareTo(o.identityvalue);
    }
}

