/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsTimeString;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="iso8601time")
public final class Iso8601Time
implements ValueObject,
Comparable<Iso8601Time>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter JODA_FORMATTER = DateTimeFormat.forPattern(IsTimeString.TIME_FORMAT.ISO.getFormat());
    private static final java.time.format.DateTimeFormatter JAVA_FORMATTER = java.time.format.DateTimeFormatter.ISO_LOCAL_TIME;
    @IsTimeString(format=IsTimeString.TIME_FORMAT.ISO)
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected Iso8601Time() {
        this.value = null;
    }

    private Iso8601Time(String value) {
        this.value = value;
    }

    private Iso8601Time(LocalTime value) {
        this.value = JODA_FORMATTER.print(value);
    }

    private Iso8601Time(java.time.LocalTime value) {
        this.value = value.format(JAVA_FORMATTER);
    }

    public static Iso8601Time fromString(String value) {
        if (value == null) {
            return null;
        }
        return new Iso8601Time(value);
    }

    public static Iso8601Time fromLocalTime(LocalTime value) {
        if (value == null) {
            return null;
        }
        return new Iso8601Time(value);
    }

    public static Iso8601Time fromLocalTime(java.time.LocalTime value) {
        if (value == null) {
            return null;
        }
        return new Iso8601Time(value);
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public java.time.LocalTime getValueAsLocalTime() {
        return java.time.LocalTime.parse(this.value, JAVA_FORMATTER);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Iso8601Time other = (Iso8601Time)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(Iso8601Time o) {
        return this.value.compareTo(o.value);
    }
}

