/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.validators.IsDateString;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="localdatestring")
public class LocalDateStringValue
implements Comparable<LocalDateStringValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern(IsDateString.DATE_FORMAT.COMPACT.getFormat());
    @IsDateString(format=IsDateString.DATE_FORMAT.COMPACT, minDate="1890-01-01")
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected LocalDateStringValue() {
        this.value = null;
    }

    private LocalDateStringValue(String value) {
        this.value = value;
    }

    private LocalDateStringValue(LocalDate value) {
        this.value = FORMATTER.print(value);
    }

    public static LocalDateStringValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new LocalDateStringValue(value);
    }

    public static LocalDateStringValue fromLocalDate(LocalDate value) {
        if (value == null) {
            return null;
        }
        return new LocalDateStringValue(value);
    }

    public String getValueAsString() {
        return this.value;
    }

    public LocalDate getValueAsLocalDate() {
        return FORMATTER.parseLocalDate(this.value);
    }

    public static Optional<String> asString(LocalDateStringValue localDateString) {
        if (localDateString == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(localDateString.getValueAsString());
    }

    public static Optional<LocalDate> asLocalDate(LocalDateStringValue localDateString) {
        if (localDateString == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(localDateString.getValueAsLocalDate());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalDateStringValue other = (LocalDateStringValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(LocalDateStringValue o) {
        return this.value.compareTo(o.value);
    }
}

