/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsASCIISimpleString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="notificationchanneltype")
public class NotificationChannelTypeValue
implements Comparable<NotificationChannelTypeValue>,
ValueObject,
Serializable {
    public static final NotificationChannelTypeValue SMS = new NotificationChannelTypeValue("SMS");
    public static final NotificationChannelTypeValue EMAIL = new NotificationChannelTypeValue("EMAIL");
    private static final long serialVersionUID = 1L;
    @IsASCIISimpleString
    @Length(max=16)
    @NotNull
    @NotBlank
    @XmlValue
    private final String value;

    protected NotificationChannelTypeValue() {
        this.value = null;
    }

    protected NotificationChannelTypeValue(String value) {
        this.value = value;
    }

    public static NotificationChannelTypeValue fromString(String value) {
        if (value == null) {
            return null;
        }
        if (NotificationChannelTypeValue.SMS.value.equals(value)) {
            return SMS;
        }
        if (NotificationChannelTypeValue.EMAIL.value.equals(value)) {
            return EMAIL;
        }
        return new NotificationChannelTypeValue(value);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public static Optional<String> asString(NotificationChannelTypeValue channelType) {
        return Optional.ofNullable(channelType != null ? channelType.value : null);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotificationChannelTypeValue other = (NotificationChannelTypeValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(NotificationChannelTypeValue o) {
        return this.value.compareTo(o.value);
    }
}

