/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.PermissionClassification;
import com.ericsson.em.m3if.v1_0.common.PermissionName;
import com.ericsson.em.m3if.v1_0.common.RegistrationProfileName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v1_0/common", name="permissiondetailsentry", propOrder={"permission", "profile", "subpermission", "classification"})
public class PermissionDetailsEntry
implements Serializable,
Comparable<PermissionDetailsEntry> {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="permission", type=PermissionName.class, required=true)
    private PermissionName permission;
    @NotNull
    @Valid
    @XmlElement(name="profile", type=RegistrationProfileName.class, required=true)
    private RegistrationProfileName profile;
    @NotNull
    @Valid
    @XmlElement(name="subpermission", type=PermissionName.class, required=true)
    private PermissionName subpermission;
    @NotNull
    @Valid
    @XmlElement(name="classification", type=PermissionClassification.class, required=true)
    private PermissionClassification classification;

    public PermissionDetailsEntry() {
    }

    public PermissionDetailsEntry(String permission, String profile, String subpermission, String classification) {
        this.permission = PermissionName.fromString(permission);
        this.profile = RegistrationProfileName.fromString(profile);
        this.subpermission = PermissionName.fromString(subpermission);
        this.classification = PermissionClassification.fromString(classification);
    }

    public PermissionName getPermission() {
        return this.permission;
    }

    public void setPermission(PermissionName permission) {
        this.permission = permission;
    }

    public RegistrationProfileName getProfile() {
        return this.profile;
    }

    public void setProfile(RegistrationProfileName profile) {
        this.profile = profile;
    }

    public PermissionName getSubpermission() {
        return this.subpermission;
    }

    public void setSubpermission(PermissionName subpermission) {
        this.subpermission = subpermission;
    }

    public PermissionClassification getClassification() {
        return this.classification;
    }

    public void setClassification(PermissionClassification classification) {
        this.classification = classification;
    }

    @Override
    public int compareTo(PermissionDetailsEntry that) {
        int permissionComparison = this.getPermission().compareTo(that.getPermission());
        if (permissionComparison != 0) {
            return permissionComparison;
        }
        if (this.getProfile() == null && that.getProfile() == null) {
            return 0;
        }
        if (this.getProfile() == null) {
            return -1;
        }
        if (that.getProfile() == null) {
            return 1;
        }
        int profileComparison = this.getProfile().compareTo(that.getProfile());
        if (profileComparison != 0) {
            return profileComparison;
        }
        if (this.getSubpermission() == null && that.getSubpermission() == null) {
            return 0;
        }
        if (this.getSubpermission() == null) {
            return -1;
        }
        if (that.getSubpermission() == null) {
            return 1;
        }
        int subpermissionComparison = this.getSubpermission().compareTo(that.getSubpermission());
        if (subpermissionComparison != 0) {
            return subpermissionComparison;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionDetailsEntry that = (PermissionDetailsEntry)o;
        return this.permission.equals(that.permission) && Objects.equals(this.profile, that.profile) && Objects.equals(this.subpermission, that.subpermission) && Objects.equals(this.classification, that.classification);
    }

    public int hashCode() {
        return Objects.hash(this.permission, this.profile, this.subpermission, this.classification);
    }
}

