/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.v2_0.common;

import com.ericsson.em.m3if.v1_0.common.AccountDescriptionValue;
import com.ericsson.em.m3if.v1_0.common.EmailAddress;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.validators.IsLanguage;
import com.ericsson.em.validators.IsMSISDN;
import com.ericsson.em.validators.IsPersonalName;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/v2_0/common", name="receiverinfo", propOrder={"accountHolderIdentity", "accountFRI", "accountDescription", "name", "msisdn", "email", "language"})
public class ReceiverInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="accountholderidentity", type=IdentityValue.class, required=true)
    private IdentityValue accountHolderIdentity;
    @Valid
    @XmlElement(name="accountfri", type=FRIValue.class)
    private FRIValue accountFRI;
    @Valid
    @XmlElement(name="accountdescription", type=AccountDescriptionValue.class)
    private AccountDescriptionValue accountDescription;
    @IsPersonalName
    @XmlElement(name="name")
    private String name;
    @NotEmpty
    @IsMSISDN
    @XmlElement(name="msisdn")
    private String msisdn;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="emailadresses")
    @XmlElement(name="email", type=EmailAddress.class)
    private List<EmailAddress> email;
    @IsLanguage
    @XmlElement(name="language")
    private String language;

    public IdentityValue getAccountHolderIdentity() {
        return this.accountHolderIdentity;
    }

    public void setAccountHolderIdentity(IdentityValue accountHolderIdentity) {
        this.accountHolderIdentity = accountHolderIdentity;
    }

    public FRIValue getAccountFRI() {
        return this.accountFRI;
    }

    public void setAccountFRI(FRIValue accountFRI) {
        this.accountFRI = accountFRI;
    }

    public AccountDescriptionValue getAccountDescription() {
        return this.accountDescription;
    }

    public void setAccountDescription(AccountDescriptionValue accountDescription) {
        this.accountDescription = accountDescription;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public List<EmailAddress> getEmail() {
        if (this.email == null) {
            this.email = new ArrayList<EmailAddress>();
        }
        return this.email;
    }

    public void addEmail(String address) {
        if (address != null) {
            this.getEmail().add(EmailAddress.fromString(address));
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

