/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validation;

import com.ericsson.em.validation.LanguagesLoader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Languages {
    public static final String DEFAULT_LANGUAGE_CODE = "default";
    private static final int ISO_639_1_CODE_LENGTH = 2;
    private static final int ISO_639_3_CODE_LENGTH = 3;
    private static final String LANGUAGES_RESOURCE = "/iso639_languages.properties";
    private static final Map<String, String> languagesCodeToName;

    public static boolean doesCodeExist(String languageCode) {
        return languagesCodeToName.containsKey(languageCode.toLowerCase());
    }

    public static String getNameByCode(String languageCode) {
        return Optional.ofNullable(languagesCodeToName.get(languageCode.toLowerCase())).orElseThrow(() -> new IllegalArgumentException("Invalid language code: " + languageCode));
    }

    public static List<String> getIso639_1BasedCodes() {
        return languagesCodeToName.keySet().stream().filter(code -> code.length() == 2).collect(Collectors.toList());
    }

    public static List<String> getIso639_3BasedCodes() {
        return languagesCodeToName.keySet().stream().filter(code -> code.length() == 3).collect(Collectors.toList());
    }

    static {
        LanguagesLoader languagesLoader = new LanguagesLoader();
        languagesCodeToName = Collections.unmodifiableMap(languagesLoader.loadFrom(LANGUAGES_RESOURCE));
    }
}

