/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.impl.IsEmailValidator;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class IsIdentityValidator
implements ConstraintValidator<IsIdentity, String> {
    private static final String IDENTITY_PREFIX = "id:";
    private static final String EMAIL_SUFFIX = "/email";
    private static final IsEmailValidator EMAIL_VALIDATOR = new IsEmailValidator();
    private static final Pattern ID_PATTERN = Pattern.compile("ID:[\\p{IsAlphabetic}\\p{IsDigit}+:.@_-]+/[a-z]+", 258);

    @Override
    public void initialize(IsIdentity constraintAnnotation) {
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext arg1) {
        if (value == null) {
            return true;
        }
        return IsIdentityValidator.isValidEmailIdentity(value) ? IsIdentityValidator.isValidEmail(value) : ID_PATTERN.matcher(value).matches();
    }

    private static boolean isValidEmailIdentity(String emailIdentity) {
        String value = emailIdentity.toLowerCase();
        return value.startsWith(IDENTITY_PREFIX) && value.endsWith(EMAIL_SUFFIX);
    }

    private static boolean isValidEmail(String email) {
        return email.length() > IDENTITY_PREFIX.length() + EMAIL_SUFFIX.length() && EMAIL_VALIDATOR.isValid(email.substring(IDENTITY_PREFIX.length(), email.length() - EMAIL_SUFFIX.length()), (ConstraintValidatorContext)null);
    }
}

