/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsPercentageString;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.math.BigDecimal;

public class IsPercentageStringValidator
implements ConstraintValidator<IsPercentageString, String> {
    private boolean allowNull;
    private int maxValue;

    @Override
    public void initialize(IsPercentageString constraintAnnotation) {
        this.allowNull = constraintAnnotation.allowNull();
        this.maxValue = constraintAnnotation.maxValue();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return this.allowNull;
        }
        try {
            BigDecimal bigDecimalValue = new BigDecimal(value);
            return bigDecimalValue.compareTo(BigDecimal.ZERO) > -1 && bigDecimalValue.compareTo(BigDecimal.valueOf(this.maxValue)) < 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

