/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsPrivacyEnhancedMail;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class IsPrivacyEnhancedMailValidator
implements ConstraintValidator<IsPrivacyEnhancedMail, String> {
    private static final String PUBLIC_KEY = "PUBLIC KEY";
    private static final String CERTIFICATE = "CERTIFICATE";
    private static final String CERTIFICATE_REQUEST = "CERTIFICATE REQUEST";
    private static final List<String> PEMBeginTags = Arrays.asList(String.format("-----BEGIN %s-----", "PUBLIC KEY"), String.format("-----BEGIN %s-----", "CERTIFICATE"), String.format("-----BEGIN %s-----", "CERTIFICATE REQUEST"));
    private static final List<String> PEMEndTags = Arrays.asList(String.format("-----END %s-----", "PUBLIC KEY"), String.format("-----END %s-----", "CERTIFICATE"), String.format("-----END %s-----", "CERTIFICATE REQUEST"));

    @Override
    public void initialize(IsPrivacyEnhancedMail constraintAnnotation) {
    }

    @Override
    public boolean isValid(String pem, ConstraintValidatorContext context) {
        int endIdx;
        if (pem == null) {
            return true;
        }
        String[] lines = pem.split("\n");
        int beginIdx = lines.length > 0 ? PEMBeginTags.indexOf(lines[0]) : -1;
        int n = endIdx = lines.length > 0 ? PEMEndTags.indexOf(lines[lines.length - 1]) : -1;
        if (beginIdx == -1) {
            return false;
        }
        if (endIdx == -1) {
            return false;
        }
        if (beginIdx != endIdx) {
            return false;
        }
        Pattern base64linePattern = Pattern.compile("[A-Za-z0-9\\+/=]{0,64}");
        for (int i = 1; i < lines.length - 1; ++i) {
            if (base64linePattern.matcher(lines[i]).matches()) continue;
            return false;
        }
        return true;
    }
}

