/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsTimeString;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IsTimeStringValidator
implements ConstraintValidator<IsTimeString, String> {
    private IsTimeString.TIME_FORMAT format;

    @Override
    public void initialize(IsTimeString parameters) {
        this.format = parameters.format();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            DateTimeFormatter sdf = DateTimeFormat.forPattern(this.format.getFormat());
            DateTime date = sdf.parseDateTime(value);
            if (date.getYear() < 1000 || date.getEra() != 1) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }
}

