/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.IsURL;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.net.MalformedURLException;
import java.net.URL;

public class IsURLValidator
implements ConstraintValidator<IsURL, String> {
    private boolean allowQuery;

    @Override
    public void initialize(IsURL annotation) {
        this.allowQuery = annotation.allowQuery();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext arg1) {
        if (value == null) {
            return true;
        }
        try {
            URL url = new URL(value);
            if (!this.allowQuery) {
                String query = url.getQuery();
                return query == null;
            }
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

