/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.validators.impl;

import com.ericsson.em.validators.Length;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class LengthValidator
implements ConstraintValidator<Length, String> {
    private int min;
    private int max;

    @Override
    public void initialize(Length annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
        this.validateParameters();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value.length() < this.min) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("{Length.tooShort_message}").addConstraintViolation();
        } else if (value.length() > this.max) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("{Length.tooLong_message}").addConstraintViolation();
        }
        return value.length() >= this.min && value.length() <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0 || this.max < 0) {
            throw new IllegalArgumentException("Min or max parameter should be positive.");
        }
        if (this.max < this.min) {
            throw new IllegalArgumentException("Max should be greater than min.");
        }
    }
}

