/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint;

import com.ericsson.ere.constraint.ConstraintModel;
import com.ericsson.ere.constraint.ConstraintReader;
import com.ericsson.ere.constraint.ConstraintReaderImpl;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.defs.RMAClassRepository;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.exception.EreException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

public class ConstraintHandler {
    private ConstraintModel myConstraintModel = ConstraintModel.createEmptyModel();

    public ConstraintHandler(Node constraintsNode) {
        if (constraintsNode != null) {
            this.populateConstraintModel(constraintsNode);
        }
    }

    protected static ConstraintHandler getFromRepository(ClassRepository rep) {
        ConstraintHandler handler = null;
        if (rep instanceof RMAClassRepository) {
            handler = ((RMAClassRepository)rep).getConstraintHandler();
        }
        return handler;
    }

    private void populateConstraintModel(Node constraintsNode) {
        List<Object> rawConstraintList = new ArrayList();
        try {
            ConstraintReader reader = ConstraintReaderImpl.getInstance(constraintsNode);
            rawConstraintList = reader.findAllConstraints();
        }
        catch (EreException ex) {
            ExceptionUtil.handleException(ex, "ratingRuleFrame", 2, "ConstraintHandler failed to read constraint configuration. No constraints will be available.", false);
        }
        if (rawConstraintList.size() != 0 && !this.myConstraintModel.addConstraintList(rawConstraintList)) {
            RmaDefs.loggerRma.severe("Constraint handler could initialize properly due to conflicts in the defined constraints. No constraints will be available.");
        }
    }

    protected List<Constraint> findConstraints(Constrainable constrainable, ConstraintTargetType targetType, ConstraintContext context) {
        if (constrainable == null || targetType == null || context == null) {
            throw new IllegalArgumentException("None of the parameters may be null.");
        }
        ArrayList<Constraint> affectingConstraintList = new ArrayList<Constraint>();
        List<Constraint> constraintsForIdList = this.myConstraintModel.getConstraintsForConstrainable(constrainable);
        for (Constraint currentConstraint : constraintsForIdList) {
            ConstraintContext currentContext = currentConstraint.getContext();
            if (!context.matches(currentContext) || currentConstraint.getTarget().getTargetType() != targetType) continue;
            affectingConstraintList.add(currentConstraint);
        }
        Collections.sort(affectingConstraintList);
        return affectingConstraintList;
    }
}

