/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint;

import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import ericsson.ere.defs.RmaDefs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;

public class ConstraintModel
extends Observable {
    private List<Constraint> myConstraintList = new ArrayList<Constraint>();
    private boolean myModified;

    private ConstraintModel() {
    }

    public static ConstraintModel createModelFromValues(List<Constraint> constraintList) {
        if (constraintList == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        return new ConstraintModel(constraintList);
    }

    private ConstraintModel(List<Constraint> constraintList) {
        this.addConstraintList(constraintList);
    }

    public List<Constraint> getConstraintList() {
        return Collections.unmodifiableList(this.myConstraintList);
    }

    public List<Constraint> getConstraintsForConstrainable(Constrainable constrainiable) {
        return this.getConstraintListForConstrainable(constrainiable, false);
    }

    public List<Constraint> getFieldConstraintsFromName(String fieldName) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint con : this.myConstraintList) {
            if (con.getTarget().getTargetType() != ConstraintTargetType.FIELD || !con.getTarget().getTargetValue().equals(fieldName) && !con.getTarget().isAll()) continue;
            result.add(con);
        }
        return result;
    }

    public List<Constraint> getConstraintListForConstrainable(Constrainable constrainable, boolean skipGeneralConstrainables) {
        ArrayList<Constraint> filteredConstraintList = new ArrayList<Constraint>();
        for (Constraint currentConstraint : this.myConstraintList) {
            if (!constrainable.matches(currentConstraint.getConstrainable())) continue;
            if (skipGeneralConstrainables) {
                if (currentConstraint.getConstrainable().isGeneral()) continue;
                filteredConstraintList.add(currentConstraint);
                continue;
            }
            filteredConstraintList.add(currentConstraint);
        }
        return filteredConstraintList;
    }

    public List<Constraint> getGeneralConstraintsFromConstrainableType(Constrainable.ConstrainableType type) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint con : this.myConstraintList) {
            if (con.getConstrainable().getType() != type || !con.getConstrainable().isGeneral()) continue;
            result.add(con);
        }
        return result;
    }

    public List<Constraint> getFieldConstraints() {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint con : this.myConstraintList) {
            if (con.getTarget().getTargetType() != ConstraintTargetType.FIELD) continue;
            result.add(con);
        }
        return result;
    }

    public boolean addConstraint(Constraint newConstraint) {
        switch (this.conflictTest(this.myConstraintList, newConstraint)) {
            case NO_CONFLICT: {
                this.myConstraintList.add(newConstraint);
                this.myModified = true;
                this.setChanged();
                this.notifyObservers();
                break;
            }
            case EQUAL_CONSTRAINT_CONFLICT: {
                break;
            }
            case OPPOSITE_CONSTRAINT_CONFLICT: {
                return false;
            }
        }
        return true;
    }

    public boolean addConstraintList(List<Constraint> constraintList) {
        ArrayList<Constraint> temporaryConstraintList = new ArrayList<Constraint>();
        temporaryConstraintList.addAll(this.myConstraintList);
        for (Constraint currentNewConstraint : constraintList) {
            switch (this.conflictTest(temporaryConstraintList, currentNewConstraint)) {
                case NO_CONFLICT: {
                    temporaryConstraintList.add(currentNewConstraint);
                    break;
                }
                case EQUAL_CONSTRAINT_CONFLICT: {
                    break;
                }
                case OPPOSITE_CONSTRAINT_CONFLICT: {
                    return false;
                }
            }
        }
        this.myConstraintList = temporaryConstraintList;
        this.myModified = true;
        return true;
    }

    private ConflictResult conflictTest(List<Constraint> temporaryConstraintList, Constraint newConstraint) {
        ConflictResult result = this.constraintConflictValidation(newConstraint, temporaryConstraintList);
        if (result == ConflictResult.EQUAL_CONSTRAINT_CONFLICT) {
            RmaDefs.loggerRma.warning("Two or more equal constraints where found when populating the ConstraintModel.");
        } else if (result == ConflictResult.OPPOSITE_CONSTRAINT_CONFLICT) {
            RmaDefs.loggerRma.warning("Two or more conflicting constraints where found when populating the ConstraintModel.");
        }
        return result;
    }

    public boolean alreadyInModel(Constraint constraint) {
        return this.constraintConflictValidation(constraint, this.myConstraintList) == ConflictResult.EQUAL_CONSTRAINT_CONFLICT;
    }

    private ConflictResult constraintConflictValidation(Constraint constraint, List<Constraint> constraintList) {
        HashMap<Constraint.Action, Integer> resultMap = new HashMap<Constraint.Action, Integer>();
        this.updateActionCountForConstraint(constraint, resultMap);
        for (Constraint con : constraintList) {
            if (!constraint.equals(con)) continue;
            this.updateActionCountForConstraint(con, resultMap);
        }
        return this.validateActionCount(resultMap);
    }

    private void updateActionCountForConstraint(Constraint con, Map<Constraint.Action, Integer> resultMap) {
        Constraint.Action action = con.getAction();
        Integer count = resultMap.get((Object)action);
        if (count == null) {
            resultMap.put(action, 1);
        } else {
            resultMap.put(action, count + 1);
        }
    }

    private ConflictResult validateActionCount(Map<Constraint.Action, Integer> resultMap) {
        int includeCount = resultMap.containsKey((Object)Constraint.Action.INCLUDE) ? resultMap.get((Object)Constraint.Action.INCLUDE) : 0;
        int excludeCount = resultMap.containsKey((Object)Constraint.Action.EXCLUDE) ? resultMap.get((Object)Constraint.Action.EXCLUDE) : 0;
        int selectCount = resultMap.containsKey((Object)Constraint.Action.SELECT) ? resultMap.get((Object)Constraint.Action.SELECT) : 0;
        ConflictResult result = ConflictResult.NO_CONFLICT;
        if (includeCount > 1 || excludeCount > 1 || selectCount > 1) {
            result = ConflictResult.EQUAL_CONSTRAINT_CONFLICT;
        } else if (includeCount + excludeCount > 1) {
            result = ConflictResult.OPPOSITE_CONSTRAINT_CONFLICT;
        }
        return result;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void resetModified() {
        this.myModified = false;
    }

    public void removeConstraint(Constraint constraint) {
        boolean wasRemoved = this.myConstraintList.remove(constraint);
        if (wasRemoved) {
            this.myModified = true;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String getXMLRepresentation() {
        if (this.myConstraintList.size() < 1) {
            return null;
        }
        StringBuilder builder = new StringBuilder("<Constraints>");
        for (Constraint con : this.myConstraintList) {
            builder.append(con.toXMLRepresentation());
        }
        builder.append("</Constraints>");
        return builder.toString();
    }

    public static ConstraintModel createEmptyModel() {
        return new ConstraintModel();
    }

    private static enum ConflictResult {
        NO_CONFLICT,
        EQUAL_CONSTRAINT_CONFLICT,
        OPPOSITE_CONSTRAINT_CONFLICT;

    }
}

