/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint;

import com.ericsson.ere.constraint.ConstraintReader;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import ericsson.ere.exception.EreException;
import ericsson.ere.xml.EreXmlException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ConstraintReaderImpl
implements ConstraintReader {
    private static final String NODE_CONSTRAINT = "Constraint";
    private static final String NODE_TARGET = "Target";
    private static final String NODE_CONTEXT = "Context";
    private static final String ATTR_CONSTR_TYPE = "constrainableType";
    private static final String ATTR_CONST_NAME = "constrainableName";
    private static final String ATTR_CONTEXT_TYPE = "contextType";
    private static final String ATTR_CONTEXT_NAME = "contextName";
    private static final String ATTR_TARGET_VALUE = "value";
    private static final String ATTR_TARGET_TYPE = "targetType";
    private static final String ATTR_ACTION = "action";
    private Element myRootElement;

    private ConstraintReaderImpl(Element constraintsElement) {
        this.myRootElement = constraintsElement;
    }

    public static ConstraintReader getInstance(Node constraintsNode) {
        if (constraintsNode == null) {
            throw new IllegalArgumentException("The supplied node object must not be null");
        }
        if (!(constraintsNode instanceof Element)) {
            throw new IllegalArgumentException("The supplied node object must be an element");
        }
        return new ConstraintReaderImpl((Element)constraintsNode);
    }

    @Override
    public List<Constraint> findAllConstraints() throws EreException {
        return this.findAllConstraintsByConstrainable(null);
    }

    private NodeList getConstraintNodes() {
        return this.myRootElement.getElementsByTagName(NODE_CONSTRAINT);
    }

    @Override
    public List<Constraint> findAllConstraintsByConstrainable(Constrainable constrainable) throws EreException {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        NodeList allConstraints = this.getConstraintNodes();
        try {
            if (allConstraints != null && this.xmlIsValid(this.myRootElement)) {
                for (int i = 0; i < allConstraints.getLength(); ++i) {
                    Element constraintElement = (Element)allConstraints.item(i);
                    if (!this.elementMatchesConstrainable(constraintElement, constrainable)) continue;
                    this.createAndAddConstraint(result, constraintElement);
                }
            }
        }
        catch (SAXException ex) {
            throw new EreXmlException("The xml fragment (i.e. <Constraints>..</Constraints>) extracted from the service definition file seems to be invalid", ex);
        }
        catch (IOException ex) {
            throw new EreException("Failed to parse/read constraints from service definition xml file", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new EreException("Failed to parse/read constraints from service definition xml file", ex);
        }
        return result;
    }

    private boolean elementMatchesConstrainable(Element e, Constrainable c) {
        if (c == null) {
            return true;
        }
        String idNameFromXml = e.getAttribute(ATTR_CONST_NAME);
        String constainableName = c.getName();
        String constainableType = c.getType().getName();
        return (constainableName.equals(idNameFromXml) || "*".equals(idNameFromXml)) && constainableType.equals(e.getAttribute(ATTR_CONSTR_TYPE));
    }

    private void createAndAddConstraint(List<Constraint> result, Element constraintNode) {
        Constrainable foundId = Constrainable.createFromNameAndType(constraintNode.getAttribute(ATTR_CONST_NAME), Constrainable.ConstrainableType.getTypeFromString(constraintNode.getAttribute(ATTR_CONSTR_TYPE)));
        ConstraintTargetType targetType = this.fetchTargetType(constraintNode);
        String targetValue = this.fetchTargetValue(constraintNode);
        ConstraintTarget foundTarget = ConstraintTarget.createTarget(targetType, targetValue);
        Constraint.ConstraintBuilder constraintBuilder = new Constraint.ConstraintBuilder(foundTarget, foundId);
        switch (Constraint.Action.forName(constraintNode.getAttribute(ATTR_ACTION))) {
            case SELECT: {
                constraintBuilder.setSelect();
                break;
            }
            case EXCLUDE: {
                constraintBuilder.setExclude();
                break;
            }
            default: {
                constraintBuilder.setInclude();
            }
        }
        ConstraintContext foundCtx = this.fetchContext(constraintNode);
        if (foundCtx != null) {
            constraintBuilder.withContext(foundCtx);
        }
        result.add(constraintBuilder.build());
    }

    private ConstraintContext fetchContext(Element constraintNode) {
        NodeList list = constraintNode.getElementsByTagName(NODE_CONTEXT);
        ConstraintContext.Builder contextBuilder = new ConstraintContext.Builder();
        if (list != null && list.getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                String type = ((Element)list.item(i)).getAttribute(ATTR_CONTEXT_TYPE);
                String name = ((Element)list.item(i)).getAttribute(ATTR_CONTEXT_NAME);
                if ("*".equals(type)) {
                    if ("*".equals(name)) {
                        return ConstraintContext.ANY_CONTEXT;
                    }
                    throw new IllegalArgumentException("For context type '*' the context name must always be '*'.");
                }
                ConstraintContextItemType itemType = ConstraintContextItemType.getTypeFromString(type);
                contextBuilder.addContext(itemType, name);
            }
        }
        return contextBuilder.build();
    }

    private String fetchTargetValue(Element constraintNode) {
        Element target = (Element)constraintNode.getElementsByTagName(NODE_TARGET).item(0);
        return target.getAttribute(ATTR_TARGET_VALUE);
    }

    private ConstraintTargetType fetchTargetType(Element constraintNode) {
        Element target = (Element)constraintNode.getElementsByTagName(NODE_TARGET).item(0);
        return ConstraintTargetType.getTypeFromString(target.getAttribute(ATTR_TARGET_TYPE));
    }

    private boolean xmlIsValid(Node constraintsNode) throws SAXException, IOException, ParserConfigurationException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(this.getClass().getResourceAsStream("/config/ere-service-schema.xsd")));
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(constraintsNode));
        return true;
    }
}

