/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint;

import com.ericsson.ere.constraint.ConstraintHandler;
import com.ericsson.ere.constraint.LegacyAutoConditionMapProfile;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItem;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatementProfile;
import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.defs.PluginName;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.leaf.AbstractModifierProfile;
import ericsson.ere.management.Service;
import ericsson.ere.structure.AbstractTariffStructureProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ConstraintService {
    private ConstraintService() {
    }

    public static List<String> constrainFields(ClassProfile profile, ClassRepository repository, List<String> candidateFieldList) {
        return ConstraintService.constrainFields(profile, new ConstraintContext.Builder().build(), repository, candidateFieldList);
    }

    public static List<String> constrainFields(ClassProfile profile, ConstraintContext context, ClassRepository repository, List<String> candidateFieldList) {
        List<FieldDefinition> fieldDefinitionCandidates = FieldDefinitionHelper.extractFieldDefinitionList(repository, candidateFieldList);
        List<FieldDefinition> constrainedFieldDefinitions = ConstraintService.constrainFieldDefinitions(profile, context, repository, fieldDefinitionCandidates);
        return ConstraintService.fieldDefinitionListToStringList(constrainedFieldDefinitions);
    }

    private static List<String> fieldDefinitionListToStringList(List<FieldDefinition> fieldDefinitions) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldDefinition fieldDefinition : fieldDefinitions) {
            fieldNames.add(fieldDefinition.getFieldName());
        }
        return fieldNames;
    }

    public static <T extends FieldHierarchyNode> List<T> constrainFieldDefinitions(ClassProfile profile, ClassRepository repository, List<T> candidateFieldList) {
        return ConstraintService.constrainFieldDefinitions(profile, new ConstraintContext.Builder().build(), repository, candidateFieldList);
    }

    public static <T extends FieldHierarchyNode> List<T> constrainFieldDefinitions(ClassProfile profile, ConstraintContext context, ClassRepository repository, List<T> candidateFieldList) {
        Constrainable constrainable = ConstraintService.createConstrainable(profile);
        boolean hasAutoConditionMapLegacy = profile.getClass().isAnnotationPresent(LegacyAutoConditionMapProfile.class);
        List<T> defaultFields = hasAutoConditionMapLegacy ? ConstraintService.extractAutoMappedFieldsAndTDFs(repository, candidateFieldList) : candidateFieldList;
        return ConstraintService.constrainFieldDefinitions(constrainable, context, repository, candidateFieldList, defaultFields);
    }

    public static <T extends FieldHierarchyNode> List<T> constrainFieldDefinitions(Constrainable constrainable, ConstraintContext context, ClassRepository repository, List<T> candidateFieldList) {
        return ConstraintService.constrainFieldDefinitions(constrainable, context, repository, candidateFieldList, candidateFieldList);
    }

    private static <T extends FieldHierarchyNode> List<T> constrainFieldDefinitions(Constrainable constrainable, ConstraintContext context, ClassRepository repository, List<T> candidateFieldList, List<T> defaultFields) {
        ConstraintHandler handler = ConstraintHandler.getFromRepository(repository);
        if (constrainable == null || handler == null) {
            return candidateFieldList;
        }
        List<Constraint> constraintList = handler.findConstraints(constrainable, ConstraintTargetType.FIELD, context);
        List<T> fieldsAllowed = ConstraintService.constrainItems(constraintList, candidateFieldList, defaultFields, new NameToFieldDefinitionConverter(repository));
        HashSet<T> uniqueFields = new HashSet<T>(fieldsAllowed);
        List<T> tdfFields = ConstraintService.extractTDFFields(defaultFields);
        uniqueFields.addAll(tdfFields);
        ArrayList<T> constrainedFieldList = new ArrayList<T>(uniqueFields);
        Collections.sort(constrainedFieldList, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getCanonicalName().compareTo(o2.getCanonicalName());
            }
        });
        return constrainedFieldList;
    }

    public static List<String> constrainFeatures(ClassProfile profile, ClassRepository repository, List<String> candidateFeatures) {
        return ConstraintService.constrainFeatures(profile, ConstraintContext.EMPTY_CONTEXT, repository, candidateFeatures);
    }

    public static List<String> constrainFeatures(ClassProfile profile, ConstraintContext context, ClassRepository repository, List<String> candidateFeatures) {
        Constrainable constrainable = ConstraintService.createConstrainable(profile);
        ConstraintHandler handler = ConstraintHandler.getFromRepository(repository);
        if (constrainable == null || handler == null) {
            return Collections.emptyList();
        }
        List<Constraint> constraintList = handler.findConstraints(constrainable, ConstraintTargetType.FEATURE, context);
        List<String> enabledFeatures = ConstraintService.constrainItems(constraintList, candidateFeatures, Collections.emptyList(), new IdentityNameConverter());
        return enabledFeatures;
    }

    private static <T extends FieldHierarchyNode> List<T> extractTDFFields(List<T> fields) {
        ArrayList<FieldHierarchyNode> tdfs = new ArrayList<FieldHierarchyNode>();
        for (FieldHierarchyNode field : fields) {
            if (!field.isLeaf() || !ConstraintService.isTDF((FieldDefinition)field)) continue;
            tdfs.add(field);
        }
        return tdfs;
    }

    public static List<String> constrainItems(ClassProfile profile, ConstraintContext context, ConstraintTargetType type, ClassRepository repository, List<String> candidateItemList) {
        if (type == ConstraintTargetType.FEATURE) {
            throw new IllegalArgumentException("Must call constrainFeatures(...) for FEATURE target type.");
        }
        Constrainable constrainable = ConstraintService.createConstrainable(profile);
        ConstraintHandler handler = ConstraintHandler.getFromRepository(repository);
        if (constrainable == null || handler == null) {
            Collections.sort(candidateItemList, String.CASE_INSENSITIVE_ORDER);
            return candidateItemList;
        }
        List<Constraint> constraintList = handler.findConstraints(constrainable, type, context);
        ArrayList<String> copyOfCandidateItemList = new ArrayList<String>(candidateItemList);
        List<String> constrainedList = ConstraintService.constrainItems(constraintList, copyOfCandidateItemList, copyOfCandidateItemList, new IdentityNameConverter());
        Collections.sort(constrainedList, String.CASE_INSENSITIVE_ORDER);
        return constrainedList;
    }

    private static <T> List<T> constrainItems(List<Constraint> constraintList, List<T> candidateItemList, List<T> defaultItemList, NameToValueConverter<T> converter) {
        HashSet<T> itemNameSet = new HashSet<T>(defaultItemList);
        for (Constraint currentConstraint : constraintList) {
            Constraint.Action action = currentConstraint.getAction();
            ConstraintTarget target = currentConstraint.getTarget();
            if (action != Constraint.Action.INCLUDE && action != Constraint.Action.EXCLUDE) continue;
            if (target.isAll()) {
                if (action == Constraint.Action.INCLUDE) {
                    itemNameSet.clear();
                    itemNameSet.addAll(candidateItemList);
                    continue;
                }
                itemNameSet.clear();
                continue;
            }
            String constrainedItemValue = target.getTargetValue();
            T valueObject = converter.convert(constrainedItemValue);
            if (action == Constraint.Action.INCLUDE && candidateItemList.contains(valueObject)) {
                itemNameSet.add(valueObject);
                continue;
            }
            itemNameSet.remove(valueObject);
        }
        return new ArrayList<T>(itemNameSet);
    }

    public static String constrainDefaultItem(ClassProfile profile, ConstraintContext context, ClassRepository repository, String[] candidateList) {
        String result = candidateList.length > 0 ? candidateList[0] : null;
        Constrainable constrainable = ConstraintService.createConstrainable(profile);
        ConstraintHandler handler = ConstraintHandler.getFromRepository(repository);
        if (handler != null) {
            List<Constraint> constraintList = handler.findConstraints(constrainable, ConstraintTargetType.CONDITION, context);
            for (Constraint currentConstraint : constraintList) {
                if (currentConstraint.getAction() != Constraint.Action.SELECT) continue;
                ConstraintTarget target = currentConstraint.getTarget();
                String constrainedItemValue = target.getTargetValue();
                if (!Arrays.asList(candidateList).contains(constrainedItemValue)) continue;
                result = constrainedItemValue;
                break;
            }
        }
        return result;
    }

    private static Constrainable createConstrainable(ClassProfile profile) {
        Constrainable result = null;
        if (profile instanceof AbstractConditionProfile) {
            result = Constrainable.createFromNameAndType(((AbstractConditionProfile)profile).getName(), Constrainable.ConstrainableType.CONDITION);
        } else if (profile instanceof AbstractModifierProfile) {
            result = Constrainable.createFromNameAndType(((AbstractModifierProfile)profile).getName(), Constrainable.ConstrainableType.MODIFIER);
        } else if (profile instanceof AbstractNodeStatementProfile) {
            result = Constrainable.createFromNameAndType(((AbstractNodeStatementProfile)profile).getName(), Constrainable.ConstrainableType.NODE);
        } else if (profile instanceof AbstractTariffStructureProfile) {
            result = Constrainable.createFromNameAndType(((AbstractTariffStructureProfile)profile).getName(), Constrainable.ConstrainableType.TARIFF_STRUCTURE);
        } else {
            throw new AssertionError((Object)("Unhandled profile type: " + profile.getClass()));
        }
        return result;
    }

    private static <T extends FieldHierarchyNode> List<T> extractAutoMappedFieldsAndTDFs(ClassRepository repository, List<T> candidateFieldList) {
        ArrayList<FieldHierarchyNode> autoMappedFieldList = new ArrayList<FieldHierarchyNode>();
        for (FieldHierarchyNode currentField : candidateFieldList) {
            if (currentField.isLeaf()) {
                FieldDefinition currentFieldDefinition = (FieldDefinition)currentField;
                if (!ConstraintService.doesFieldExistInClassRepository(currentField.getCanonicalName(), repository) || !currentFieldDefinition.isAutoConditionMapAllowed() && !ConstraintService.isTDF(currentFieldDefinition)) continue;
                autoMappedFieldList.add(currentField);
                continue;
            }
            FieldStructure currentFieldStructure = (FieldStructure)currentField;
            if (!currentFieldStructure.isAutoConditionMapAllowed()) continue;
            autoMappedFieldList.add(currentField);
        }
        return autoMappedFieldList;
    }

    private static boolean isTDF(FieldDefinition currentFieldDefinition) {
        return currentFieldDefinition.getParameterType().equals("INTERNAL");
    }

    public static boolean doesFieldConstraintExistInService(Constraint constraint, Service service) {
        if (constraint == null || service == null) {
            throw new IllegalArgumentException("Argument(s) must not be null");
        }
        ClassRepository cr = service.getClassRepository();
        String fieldName = constraint.getTarget().getTargetValue();
        return ConstraintService.doesFieldExistInClassRepository(fieldName, cr);
    }

    private static boolean doesFieldExistInClassRepository(String fieldNameToVerify, ClassRepository cr) {
        return cr.getFieldRepository().getFieldByName(fieldNameToVerify) != null;
    }

    public static boolean doesPluginConstraintExistInService(Constraint constraint, Service service) {
        if (constraint == null || service == null) {
            throw new IllegalArgumentException("Argument(s) must not be null");
        }
        ClassRepository cr = service.getClassRepository();
        return ConstraintService.checkExistensForConstraint(constraint, cr);
    }

    private static boolean checkExistensForConstraint(Constraint constraint, ClassRepository cr) {
        return ConstraintService.checkConstrainable(constraint, cr) && ConstraintService.checkTarget(constraint, cr) && ConstraintService.checkCtx(constraint, cr);
    }

    private static boolean checkConstrainable(Constraint constraint, ClassRepository cr) {
        List<PluginName> plugins;
        Constrainable.ConstrainableType ct = constraint.getConstrainable().getType();
        switch (ct) {
            case MODIFIER: {
                plugins = cr.getModifierList();
                break;
            }
            case CONDITION: {
                plugins = ConstraintService.getConditionsList(cr);
                break;
            }
            case NODE: {
                plugins = ConstraintService.getNodeList(cr);
                break;
            }
            case TARIFF_STRUCTURE: {
                plugins = ConstraintService.getTariffStructureList(cr);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled constrainable type: " + (Object)((Object)ct)));
            }
        }
        return constraint.getConstrainable().isGeneral() || ConstraintService.doesNameExistInPluginList(plugins, constraint.getConstrainable().getName());
    }

    private static boolean doesNameExistInPluginList(List<PluginName> plugins, String pluginToMatch) {
        for (PluginName name : plugins) {
            String currentPlugin = name.getName();
            if (!currentPlugin.equalsIgnoreCase(pluginToMatch)) continue;
            return true;
        }
        return false;
    }

    private static List<PluginName> getNodeList(ClassRepository cr) {
        String[] nodes = cr.getNodeTypeNames();
        ArrayList<PluginName> plugins = new ArrayList<PluginName>(nodes.length);
        for (String nt : nodes) {
            plugins.add(new PluginName(nt, null));
        }
        return plugins;
    }

    private static List<PluginName> getTariffStructureList(ClassRepository cr) {
        String[] tariffStructureNames = cr.getTariffStructureNames();
        ArrayList<PluginName> plugins = new ArrayList<PluginName>(tariffStructureNames.length);
        for (String name : tariffStructureNames) {
            plugins.add(new PluginName(name, null));
        }
        return plugins;
    }

    private static List<PluginName> getConditionsList(ClassRepository cr) {
        ArrayList<PluginName> plugins = new ArrayList<PluginName>(cr.getBaseConditionList());
        plugins.addAll(cr.getDefinedConditionList());
        return plugins;
    }

    private static boolean checkTarget(Constraint constraint, ClassRepository cr) {
        List<PluginName> plugins = null;
        if (constraint.getTarget().isAll()) {
            return true;
        }
        ConstraintTargetType ctt = constraint.getTarget().getTargetType();
        switch (ctt) {
            case FEATURE: 
            case OPERATION: {
                return true;
            }
            case FIELD: {
                return ConstraintService.doesFieldExistInClassRepository(constraint.getTarget().getTargetValue(), cr);
            }
            case MODIFIER: {
                plugins = cr.getModifierList();
                return ConstraintService.doesNameExistInPluginList(plugins, constraint.getTarget().getTargetValue());
            }
            case CONDITION: {
                plugins = ConstraintService.getConditionsList(cr);
                return ConstraintService.doesNameExistInPluginList(plugins, constraint.getTarget().getTargetValue());
            }
        }
        throw new AssertionError((Object)("Unhandled target type: " + (Object)((Object)ctt)));
    }

    private static boolean checkCtx(Constraint constraint, ClassRepository cr) {
        boolean exist = false;
        ConstraintContext ctx = constraint.getContext();
        if (ctx.isEmptyContext() || ctx.isAnyContext()) {
            exist = true;
        } else {
            for (Map.Entry<ConstraintContextItemType, ConstraintContextItem> entry : ctx.getContextMap().entrySet()) {
                ConstraintContextItem ctxItem;
                ConstraintContextItemType ctxType = entry.getKey();
                if (ConstraintService.ctxExist(ctxType, ctxItem = entry.getValue(), cr)) {
                    exist = true;
                    continue;
                }
                exist = false;
                break;
            }
        }
        return exist;
    }

    private static boolean ctxExist(ConstraintContextItemType ctxType, ConstraintContextItem ctxItem, ClassRepository cr) {
        if (ctxItem.isAny()) {
            return true;
        }
        switch (ctxType) {
            case OPERATION: {
                return true;
            }
            case FIELD: {
                return ConstraintService.doesFieldExistInClassRepository(ctxItem.getValue(), cr);
            }
            case CONDITION: {
                return ConstraintService.doesNameExistInPluginList(ConstraintService.getConditionsList(cr), ctxItem.getValue());
            }
            case MODIFIER: {
                return ConstraintService.doesNameExistInPluginList(cr.getModifierList(), ctxItem.getValue());
            }
        }
        throw new AssertionError((Object)("Unhandled context item type: " + (Object)((Object)ctxType)));
    }

    private static class NameToFieldDefinitionConverter<T extends FieldHierarchyNode>
    implements NameToValueConverter<T> {
        private ClassRepository myRepository;

        NameToFieldDefinitionConverter(ClassRepository rep) {
            this.myRepository = rep;
        }

        @Override
        public T convert(String name) {
            return (T)this.myRepository.getFieldRepository().getFieldByName(name);
        }
    }

    private static class IdentityNameConverter
    implements NameToValueConverter<String> {
        private IdentityNameConverter() {
        }

        @Override
        public String convert(String name) {
            return name;
        }
    }

    private static interface NameToValueConverter<T> {
        public T convert(String var1);
    }
}

