/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint.contract;

import com.ericsson.ere.constraint.contract.ConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldRepository;
import ericsson.ere.interfaces.FieldHierarchyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public abstract class AbstractConstrainableProfileContract
implements ConstrainableProfileContract {
    private ClassRepository myRepository;

    protected AbstractConstrainableProfileContract(ClassRepository repository) {
        this.myRepository = repository;
    }

    @Override
    public Collection<ConstraintTarget> getConstraintFields(ConstraintContext context) {
        ArrayList<ConstraintTarget> result = new ArrayList<ConstraintTarget>();
        Collection<ConstraintTarget> targets = this.getConstraintTargets(ConstraintTargetType.FIELD, context);
        FieldRepository fieldRep = this.myRepository.getFieldRepository();
        for (ConstraintTarget target : targets) {
            FieldHierarchyNode node = fieldRep.getFieldByName(target.getTargetValue());
            if (node == null) continue;
            result.add(target);
        }
        return result;
    }

    protected final ClassRepository classRepository() {
        return this.myRepository;
    }

    @Override
    public Collection<ConstraintTarget> getConstraintTargets(ConstraintTargetType type, ConstraintContext context) {
        Set<ConstraintContextItemType> actualItemTypeSet;
        ConstraintContextItemType[] actualContextItemTypes;
        ConstraintSpecification needle;
        Set<ConstraintSpecification> haystack = this.supportedConstraintSpecifications();
        if (!haystack.contains(needle = ConstraintSpecification.of(type, actualContextItemTypes = (actualItemTypeSet = context.getContextMap().keySet()).toArray(new ConstraintContextItemType[actualItemTypeSet.size()])))) {
            throw new IllegalArgumentException("Type and context do not match a supported target type specification.");
        }
        return this.getConstraintTargetsImpl(type, context);
    }

    protected Collection<ConstraintTarget> namesToTargets(Collection<String> names, ConstraintTargetType type) {
        ArrayList<ConstraintTarget> list = new ArrayList<ConstraintTarget>();
        for (String name : names) {
            ConstraintTarget ct = ConstraintTarget.createTarget(type, name);
            list.add(ct);
        }
        return list;
    }

    protected abstract Collection<ConstraintTarget> getConstraintTargetsImpl(ConstraintTargetType var1, ConstraintContext var2);
}

