/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint.contract;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

@Immutable
public final class ConstraintSpecification {
    private final ConstraintTargetType myTargetType;
    private final Set<ConstraintContextItemType> myContextItemTypes;
    private final boolean myIsAny;
    private final Set<Constraint.Action> myAdditionalActions;

    private ConstraintSpecification(ConstraintTargetType targetType, Set<ConstraintContextItemType> itemTypes, boolean isAny, Set<Constraint.Action> aditionalActions) {
        this.myTargetType = targetType;
        this.myContextItemTypes = itemTypes;
        this.myIsAny = isAny;
        this.myAdditionalActions = aditionalActions;
    }

    public ConstraintTargetType getTargetType() {
        return this.myTargetType;
    }

    public Set<ConstraintContextItemType> getContextItemTypes() {
        return Collections.unmodifiableSet(this.myContextItemTypes);
    }

    public boolean representsAnyContext() {
        return this.myIsAny;
    }

    public static ConstraintSpecification of(ConstraintTargetType type, ConstraintContextItemType ... itemTypes) {
        EnumSet<ConstraintContextItemType> itemTypeSet = EnumSet.noneOf(ConstraintContextItemType.class);
        for (ConstraintContextItemType t : itemTypes) {
            itemTypeSet.add(t);
        }
        return new ConstraintSpecification(type, itemTypeSet, false, EnumSet.noneOf(Constraint.Action.class));
    }

    public static ConstraintSpecification any(ConstraintTargetType type) {
        return new ConstraintSpecification(type, EnumSet.noneOf(ConstraintContextItemType.class), true, EnumSet.noneOf(Constraint.Action.class));
    }

    public static ConstraintSpecification constraintSpecificationFromConstraint(Constraint constraint) {
        ConstraintTargetType tt = constraint.getTarget().getTargetType();
        ConstraintContext ctx = constraint.getContext();
        ConstraintSpecification spec = ctx.isAnyContext() ? ConstraintSpecification.any(tt) : ConstraintSpecification.of(tt, ctx.getContextMap().keySet().toArray(new ConstraintContextItemType[0]));
        return spec;
    }

    public boolean supportsAdditionalAction(Constraint.Action action) {
        return this.myAdditionalActions.contains((Object)action);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myContextItemTypes == null ? 0 : this.myContextItemTypes.hashCode());
        result = 31 * result + (this.myIsAny ? 1231 : 1237);
        result = 31 * result + (this.myTargetType == null ? 0 : this.myTargetType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintSpecification other = (ConstraintSpecification)obj;
        if (this.myContextItemTypes == null ? other.myContextItemTypes != null : !this.myContextItemTypes.equals(other.myContextItemTypes)) {
            return false;
        }
        if (this.myIsAny != other.myIsAny) {
            return false;
        }
        return this.myTargetType == other.myTargetType;
    }

    public boolean isSpecificationOf(Constraint c) {
        if (c.getTarget().getTargetType() != this.myTargetType) {
            return false;
        }
        if (c.getContext().isAnyContext() != this.myIsAny) {
            return false;
        }
        return c.getContext().getContextMap().keySet().equals(this.myContextItemTypes);
    }

    public String toString() {
        return String.format("(%s, %s)", new Object[]{this.myTargetType, this.myIsAny ? "[*]" : this.myContextItemTypes});
    }

    public static ConstraintSpecificationBuilder buildSpecificationWithTarget(ConstraintTargetType type) {
        return new ConstraintSpecificationBuilder(type);
    }

    public static class ConstraintSpecificationBuilder {
        private final ConstraintTargetType myBuilderTagetType;
        private Set<ConstraintContextItemType> myBuilderContextTypes = EnumSet.noneOf(ConstraintContextItemType.class);
        private Set<Constraint.Action> myBuilderAdditionalActions = EnumSet.noneOf(Constraint.Action.class);
        private boolean myBuilderIsAny = false;

        public ConstraintSpecificationBuilder(ConstraintTargetType type) {
            this.myBuilderTagetType = type;
        }

        public ConstraintSpecificationBuilder withContext(ConstraintContextItemType ... types) {
            this.myBuilderContextTypes = EnumSet.noneOf(ConstraintContextItemType.class);
            for (ConstraintContextItemType t : types) {
                this.myBuilderContextTypes.add(t);
            }
            this.myBuilderIsAny = false;
            return this;
        }

        public ConstraintSpecificationBuilder withAnyContext() {
            this.myBuilderIsAny = true;
            this.myBuilderContextTypes = EnumSet.noneOf(ConstraintContextItemType.class);
            return this;
        }

        public ConstraintSpecificationBuilder andAdditionalActions(Constraint.Action ... actions) {
            this.myBuilderAdditionalActions = EnumSet.noneOf(Constraint.Action.class);
            for (Constraint.Action a : actions) {
                this.myBuilderAdditionalActions.add(a);
            }
            return this;
        }

        public ConstraintSpecification build() {
            return new ConstraintSpecification(this.myBuilderTagetType, this.myBuilderContextTypes, this.myBuilderIsAny, this.myBuilderAdditionalActions);
        }
    }
}

