/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint.entity;

public class Constrainable
implements Comparable<Constrainable> {
    private static final String GENERAL_CONSTRAINABLE = "*";
    private static final String ALL_CONDITIONS_NAME = "All Conditions";
    private static final String ALL_MODIFIERS_NAME = "All Modifiers";
    private static final String ALL_NODES_NAME = "All Nodes";
    private static final String ALL_TARIFF_STRUCTURES_NAME = "All Tariff structures";
    private String myName;
    private ConstrainableType myType;

    public static Constrainable createFromNameAndType(String name, ConstrainableType type) {
        if (name == null || type == null) {
            throw new IllegalArgumentException("Argument(s) must not be null");
        }
        return new Constrainable(name, type);
    }

    public static Constrainable createGeneral(ConstrainableType type) {
        return new Constrainable(GENERAL_CONSTRAINABLE, type);
    }

    public boolean isGeneral() {
        return GENERAL_CONSTRAINABLE.equals(this.myName);
    }

    Constrainable(String name, ConstrainableType type) {
        this.myName = name;
        this.myType = type;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        String name;
        block7: {
            block6: {
                if (!this.isGeneral()) break block6;
                switch (this.getType()) {
                    case CONDITION: {
                        name = ALL_CONDITIONS_NAME;
                        break block7;
                    }
                    case MODIFIER: {
                        name = ALL_MODIFIERS_NAME;
                        break block7;
                    }
                    case NODE: {
                        name = ALL_NODES_NAME;
                        break block7;
                    }
                    case TARIFF_STRUCTURE: {
                        name = ALL_TARIFF_STRUCTURES_NAME;
                        break block7;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled type: " + (Object)((Object)this.getType())));
                    }
                }
            }
            name = this.myName;
        }
        return name;
    }

    public ConstrainableType getType() {
        return this.myType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myType == null ? 0 : this.myType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constrainable other = (Constrainable)obj;
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        return !(this.myType == null ? other.myType != null : !this.myType.equals((Object)other.myType));
    }

    @Override
    public int compareTo(Constrainable o) {
        if (this.isGeneral()) {
            return o.isGeneral() ? 0 : -1;
        }
        return o.isGeneral() ? 1 : 0;
    }

    public boolean matches(Constrainable otherConstraintID) {
        if (this.myType == otherConstraintID.myType) {
            return otherConstraintID.getName().equals(GENERAL_CONSTRAINABLE) || this.myName.equals(otherConstraintID.getName());
        }
        return false;
    }

    public static enum ConstrainableType {
        CONDITION("condition"),
        MODIFIER("modifier"),
        NODE("node"),
        TARIFF_STRUCTURE("tariff_structure");

        private String myName;

        private ConstrainableType(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public static ConstrainableType getTypeFromString(String attribute) {
            for (ConstrainableType cr : ConstrainableType.values()) {
                if (!attribute.equalsIgnoreCase(cr.getName())) continue;
                return cr;
            }
            throw new IllegalArgumentException("The attribute '" + attribute + "' does not match any ConstrainableType enumeration constant.");
        }
    }
}

