/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.constraint.entity;

import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItem;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import java.util.Locale;
import java.util.Map;

public final class Constraint
implements Comparable<Constraint>,
Cloneable {
    private ConstraintContext myContext = ConstraintContext.EMPTY_CONTEXT;
    private ConstraintTarget myTarget;
    private Constrainable myConstrainable;
    private Action myAction = Action.INCLUDE;

    private Constraint(ConstraintTarget target, Constrainable id) {
        this.myTarget = target;
        this.myConstrainable = id;
    }

    @Deprecated
    public boolean isInclude() {
        return this.myAction == Action.INCLUDE;
    }

    public Action getAction() {
        return this.myAction;
    }

    public ConstraintContext getContext() {
        return this.myContext;
    }

    public ConstraintTarget getTarget() {
        return this.myTarget;
    }

    public Constrainable getConstrainable() {
        return this.myConstrainable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myConstrainable == null ? 0 : this.myConstrainable.hashCode());
        result = 31 * result + (this.myContext == null ? 0 : this.myContext.hashCode());
        result = 31 * result + (this.myTarget == null ? 0 : this.myTarget.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constraint other = (Constraint)obj;
        if (this.myConstrainable == null ? other.myConstrainable != null : !this.myConstrainable.equals(other.myConstrainable)) {
            return false;
        }
        if (this.myContext == null ? other.myContext != null : !this.myContext.equals(other.myContext)) {
            return false;
        }
        return !(this.myTarget == null ? other.myTarget != null : !this.myTarget.equals(other.myTarget));
    }

    public String toXMLRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("<Constraint constrainableType=\"");
        builder.append(this.getConstrainable().getType().getName());
        builder.append("\" constrainableName=\"");
        builder.append(this.getConstrainable().getName());
        builder.append("\" action=\"");
        builder.append(this.myAction.getXMLRepresentation());
        builder.append("\">");
        builder.append("<Target targetType=\"");
        builder.append(this.getTarget().getTargetType().getName());
        builder.append("\" value=\"");
        builder.append(this.getTarget().isAll() ? "*" : this.getTarget().getTargetValue());
        builder.append("\"/>");
        if (this.myContext != null) {
            if (this.myContext.isAnyContext()) {
                builder.append("<Context contextType=\"*\" contextName=\"*\" /> ");
            } else {
                for (Map.Entry<ConstraintContextItemType, ConstraintContextItem> entry : this.myContext.getContextMap().entrySet()) {
                    builder.append("<Context contextType=\"");
                    builder.append(entry.getKey().getName());
                    builder.append("\" contextName=\"");
                    builder.append(entry.getValue().getValue());
                    builder.append("\" /> ");
                }
            }
        }
        builder.append("</Constraint>\n");
        return builder.toString();
    }

    @Override
    public int compareTo(Constraint o) {
        if (this.myConstrainable.compareTo(o.myConstrainable) != 0) {
            return this.myConstrainable.getName().equals("*") ? -1 : 1;
        }
        if (this.myContext.compareTo(o.myContext) != 0) {
            return this.myContext.compareTo(o.myContext);
        }
        if (this.myTarget.compareTo(o.myTarget) != 0) {
            return this.myTarget.isAll() ? -1 : 1;
        }
        return 0;
    }

    public String describe(Locale locale) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myAction.getDescription()).append(" ").append(this.myTarget.describe(locale));
        String cstring = this.myContext.describe(locale);
        if (this.myContext.isAnyContext()) {
            builder.append(" ").append(cstring);
        } else if (cstring.length() > 0) {
            builder.append(" when ").append(cstring);
        }
        builder.append(" for ").append(this.myConstrainable);
        return builder.toString();
    }

    public String toString() {
        return this.describe(Locale.US);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)"Can not happen");
        }
    }

    public static final class ConstraintBuilder {
        private Action myBuilderAction = Action.INCLUDE;
        private ConstraintTarget myBuilderTarget;
        private Constrainable myBuilderConstrainable;
        private ConstraintContext myBuilderContext;

        public ConstraintBuilder(ConstraintTarget target, Constrainable constrainable) {
            if (target == null || constrainable == null) {
                throw new IllegalArgumentException("Arguments must not be null");
            }
            this.myBuilderTarget = target;
            this.myBuilderConstrainable = constrainable;
        }

        public ConstraintBuilder setInclude() {
            this.myBuilderAction = Action.INCLUDE;
            return this;
        }

        public ConstraintBuilder setExclude() {
            this.myBuilderAction = Action.EXCLUDE;
            return this;
        }

        public ConstraintBuilder setSelect() {
            this.myBuilderAction = Action.SELECT;
            return this;
        }

        public ConstraintBuilder withContext(ConstraintContext ctx) {
            this.myBuilderContext = ctx;
            return this;
        }

        public Constraint build() {
            Constraint constraint = new Constraint(this.myBuilderTarget, this.myBuilderConstrainable);
            constraint.myAction = this.myBuilderAction;
            if (this.myBuilderContext != null) {
                constraint.myContext = this.myBuilderContext;
            }
            return constraint;
        }
    }

    public static enum Action {
        INCLUDE{

            @Override
            protected String getXMLRepresentation() {
                return "include";
            }

            @Override
            public String getDescription() {
                return "Include";
            }
        }
        ,
        EXCLUDE{

            @Override
            protected String getXMLRepresentation() {
                return "exclude";
            }

            @Override
            public String getDescription() {
                return "Exclude";
            }
        }
        ,
        SELECT{

            @Override
            protected String getXMLRepresentation() {
                return "select";
            }

            @Override
            public String getDescription() {
                return "Select";
            }
        };


        public static Action forName(String name) {
            String ucName = name.toUpperCase();
            for (Action currentAction : Action.values()) {
                if (!currentAction.name().equals(ucName)) continue;
                return currentAction;
            }
            return INCLUDE;
        }

        abstract String getXMLRepresentation();

        public abstract String getDescription();
    }
}

