/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dag;

import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import java.util.ArrayList;
import java.util.List;

public class BaseDAGNode
extends AbstractDAGNode {
    private final List<DAGNode> myChildren = new ArrayList<DAGNode>();

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        int index = DAGUtil.indexOf(child, this.myChildren);
        if (index >= 0) {
            this.myChildren.set(index, replacement);
        }
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        return this.myChildren.get(index);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public void insertChildAt(int index, DAGNode node) {
        this.myChildren.add(index, node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) {
        node.addReferer(this);
        this.myChildren.add(index, node);
    }

    @Override
    protected void removeChild(DAGNode node) {
        if (this.myChildren.remove(node)) {
            node.setParent(null);
        }
    }

    @Override
    protected void removeLink(DAGNode node) {
        if (this.myChildren.remove(node)) {
            node.removeReferer(this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myChildren == null ? 0 : this.myChildren.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        BaseDAGNode other = (BaseDAGNode)obj;
        return !(this.myChildren == null ? other.myChildren != null : !this.myChildren.equals(other.myChildren));
    }
}

