/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.dataset.ClearableValueDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetAccessor;
import com.ericsson.ere.dataset.DefaultDataSetAccessor;
import com.ericsson.ere.dataset.DefaultDataSetPrinter;
import com.ericsson.ere.dataset.LegacyDataSetDiffHelper;
import com.ericsson.ere.dataset.STQStack;
import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.dataset.task.DefaultTask;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.executor.DefaultTreeExecutor;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.selectiontree.NoTreeFoundException;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.NoActionStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import com.ericsson.ere.selectiontree.structures.PeriodTreeDescription;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeTariffStructure;
import com.ericsson.ere.trace.TraceOrderHandler;
import com.ericsson.ere.trace.TraceTreeException;
import com.ericsson.ere.trace.TraceTreeInfo;
import ericsson.ere.datatype.factory.DefaultAmountFactory;
import ericsson.ere.datatype.interfaces.AmountFactory;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.exception.RatingException;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public abstract class AbstractDataSet
implements DataSet,
STQStack,
ClearableValueDataSet {
    private static final DefaultDataSetPrinter DATASET_DIFF_PRINTER = new DefaultDataSetPrinter();
    protected DataSetAccessor myAccessor;
    protected Calendar myStartTime = null;
    protected Calendar myCurrentTime = null;
    protected Service myService = null;
    protected TariffStructure myLatestTree = null;
    protected boolean myModifiedExcecutedFlag = false;
    private int myModifierExecutionCount = 0;
    protected TraceOrderHandler myTraceOrderHandler = null;
    private boolean myIsExecutingWithTrace = false;
    protected HashMap<Object, Object> myStates = null;
    protected TreeTask myTask = null;
    private EreManager myEreManager = null;
    protected List<PeriodTreeDescription> myPeridTreeDescriptionList = new LinkedList<PeriodTreeDescription>();
    protected String myCurrentServiceProvider;
    protected RatingPlan myCurrentRatingPlan;
    protected String myCurrentRatingPeriod;
    private RangeStrategy myFORangeStrategy = new NoActionStrategy();
    private RangeStrategy mySFRangeStrategy = new NoActionStrategy();
    private Stack<SelectionTreeQualifier> mySTQStack = new Stack();
    private TreeExecutor myTreeExecutor = new DefaultTreeExecutor();

    public AbstractDataSet() {
        this.myTraceOrderHandler = new TraceOrderHandler();
    }

    public AbstractDataSet(Service service) {
        this.myService = service;
        this.myTraceOrderHandler = new TraceOrderHandler();
    }

    @Deprecated
    public AbstractDataSet(AbstractDataSet set) {
        throw new UnsupportedOperationException("Cloning via copy constructor not supported.");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractDataSet set = (AbstractDataSet)super.clone();
        if (this.myCurrentTime != null) {
            set.myCurrentTime = (Calendar)this.myCurrentTime.clone();
        }
        if (this.myTask != null) {
            set.myTask = (TreeTask)this.myTask.clone();
            set.myTask.setDataSet(set);
        }
        set.mySTQStack = new Stack();
        set.mySTQStack.addAll(this.mySTQStack);
        set.myPeridTreeDescriptionList = new LinkedList<PeriodTreeDescription>(this.myPeridTreeDescriptionList);
        set.myAccessor = null;
        return set;
    }

    @Override
    public void execute(RatingPlan plan, Calendar startTime) {
        this.checkTask();
        try {
            this.setStartTime(startTime);
            RatingPeriod period = plan.getActualRatingPeriod(startTime);
            TraceNodeInterface lastExecutedTraceNode = null;
            TariffStructure previousLatestTree = this.myLatestTree;
            if (this.myIsExecutingWithTrace) {
                lastExecutedTraceNode = this.myTraceOrderHandler.getCurrentExecutingTraceNode();
                this.myLatestTree = period.getTraceTariffStructureForDataSet();
                if (lastExecutedTraceNode != null) {
                    ((TraceNodeInterface)((Object)this.myLatestTree)).setParent(lastExecutedTraceNode);
                }
            } else {
                this.myLatestTree = period.getTariffStructureForDataSet();
            }
            boolean swapService = plan.getService() != null && plan.getService() != this.myService;
            Service originalService = this.myService;
            try {
                if (swapService) {
                    this.myService = plan.getService();
                }
                TreeExecutorHelper.executeTariffStructure(this.myLatestTree, this);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (previousLatestTree != null) {
                    if (this.myIsExecutingWithTrace && lastExecutedTraceNode != null) {
                        lastExecutedTraceNode.addChild((TraceNodeInterface)((Object)this.myLatestTree));
                    }
                    this.myLatestTree = previousLatestTree;
                }
                if (swapService) {
                    this.myService = originalService;
                }
            }
        }
        catch (TreeExecutionException e) {
            throw e;
        }
        catch (TraceTreeException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new TreeExecutionException(e.getCause());
        }
        catch (Exception e) {
            if (e instanceof RatingException) {
                if (((RatingException)e).getErrorCode() == 7) {
                    throw new NoTreeFoundException(e.getMessage());
                }
            }
            throw new TreeExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceTreeInfo executeWithTrace(RatingPlan plan, Calendar startTime) {
        RatingPeriod period;
        this.checkTask();
        this.myIsExecutingWithTrace = true;
        DataSet originalSet = null;
        this.setStartTime(startTime);
        try {
            period = plan.getActualRatingPeriod(startTime);
        }
        catch (RatingException e) {
            throw new NoTreeFoundException(e);
        }
        TreeExecutor oldExecutor = this.getTreeExecutor();
        this.setTreeExecutor(new DefaultTreeExecutor());
        boolean swapService = plan.getService() != null && plan.getService() != this.myService;
        Service originalService = this.myService;
        try {
            originalSet = (DataSet)this.clone();
            this.myLatestTree = period.getTraceTariffStructureForDataSet();
            if (swapService) {
                this.myService = plan.getService();
            }
            TreeExecutorHelper.executeTariffStructure(this.myLatestTree, this);
        }
        catch (Exception exception) {
        }
        finally {
            if (swapService) {
                this.myService = originalService;
            }
            this.setTreeExecutor(oldExecutor);
        }
        return new TraceTreeInfo((TraceNodeTariffStructure)this.myLatestTree, originalSet, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeWithTrace(TraceNodeTariffStructure tariff) {
        this.checkTask();
        this.myIsExecutingWithTrace = true;
        TreeExecutor oldExecutor = this.getTreeExecutor();
        this.setTreeExecutor(new DefaultTreeExecutor());
        try {
            this.myLatestTree = tariff;
            TreeExecutorHelper.executeTariffStructure(this.myLatestTree, this);
        }
        catch (Exception exception) {
        }
        finally {
            this.setTreeExecutor(oldExecutor);
        }
    }

    private void checkTask() {
        if (this.myTask == null) {
            this.myTask = new DefaultTask();
        }
    }

    @Override
    public void reExecute() {
        if (this.myLatestTree == null) {
            throw new TreeExecutionException("DataSet has not yet been executed");
        }
        this.myLatestTree.execute(this);
    }

    @Override
    public TreeTask getTreeTask() {
        if (this.myTask == null) {
            this.myTask = new DefaultTask();
        }
        return this.myTask;
    }

    @Override
    public void setTreeTask(TreeTask task) {
        this.myTask = task;
        task.setDataSet(this);
    }

    @Override
    public void setTraceOrderHandler(TraceOrderHandler handler) {
        this.myTraceOrderHandler = handler;
    }

    @Override
    public TraceOrderHandler getTraceOrderHandler() {
        return this.myTraceOrderHandler;
    }

    @Override
    public void allocateTime(int second) {
        this.getCurrentTime().add(13, second);
    }

    @Override
    public Calendar getCurrentTime() {
        if (this.myCurrentTime == null) {
            if (this.myStartTime == null) {
                throw new NullPointerException("Start time has not been set.");
            }
            this.myCurrentTime = (Calendar)this.myStartTime.clone();
        }
        return this.myCurrentTime;
    }

    @Override
    public void setCurrentTime(Calendar currentTime) {
        this.myCurrentTime = currentTime;
    }

    @Override
    public Calendar getStartTime() {
        return this.myStartTime;
    }

    public void setStartTime(Calendar time) {
        this.myStartTime = time;
    }

    @Override
    public Service getService() {
        return this.myService;
    }

    @Deprecated
    public void setServie(Service service) {
        this.setService(service);
    }

    public void setService(Service service) {
        this.myService = service;
    }

    @Override
    public void modifierExecuted() {
        this.myModifiedExcecutedFlag = true;
        ++this.myModifierExecutionCount;
    }

    public void resetModifierExecuted() {
        this.myModifiedExcecutedFlag = false;
    }

    @Override
    public boolean hasModifierBeenExecuted() {
        return this.myModifiedExcecutedFlag;
    }

    @Override
    public int getModifierExecutionCount() {
        return this.myModifierExecutionCount;
    }

    @Override
    public String diffDataSet(DataSet newSet) {
        return DATASET_DIFF_PRINTER.getDataSetDiff(this, newSet);
    }

    @Deprecated
    protected static void printField(FieldDefinition fd, Object value, StringBuilder buf, String indent) {
        DefaultDataSetPrinter.printField(null, fd, value, buf, indent);
    }

    @Deprecated
    protected static void diffLongArray(boolean isSigned, String fieldName, Long[] ownLongValues, Long[] newLongValues, StringBuilder buf) {
        LegacyDataSetDiffHelper.diffLongArray(isSigned, fieldName, ownLongValues, newLongValues, buf);
    }

    @Deprecated
    protected static void diffIntegerArray(boolean isSigned, String fieldName, Integer[] ownIntValues, Integer[] newIntValues, StringBuilder buf) {
        LegacyDataSetDiffHelper.diffIntegerArray(isSigned, fieldName, ownIntValues, newIntValues, buf);
    }

    @Deprecated
    protected static void diffShortArray(boolean isSigned, String fieldName, Short[] ownShortValues, Short[] newShortValues, StringBuilder buf) {
        LegacyDataSetDiffHelper.diffShortArray(isSigned, fieldName, ownShortValues, newShortValues, buf);
    }

    @Deprecated
    protected static void diffDoubleArray(String fieldName, Double[] ownDoubleValues, Double[] newDoubleValues, StringBuilder buf) {
        LegacyDataSetDiffHelper.diffDoubleArray(fieldName, ownDoubleValues, newDoubleValues, buf);
    }

    @Override
    public void printTraceHead(PrintWriter writer) {
        if (this.myStartTime != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeString = formatter.format(this.myStartTime.getTime());
            writer.println("Current time:       " + timeString);
            writer.println();
        }
        writer.println("Print out of data set:");
        writer.println(this.toString());
    }

    @Override
    public void printTraceTail(PrintWriter writer, DataSet originalDataSet) {
        String theTraceDiff = originalDataSet.diffDataSet(this);
        if (theTraceDiff != null && theTraceDiff.length() > 0) {
            writer.println();
            writer.println();
            writer.println("Parameters that were changed:");
            writer.println(theTraceDiff);
        }
    }

    @Override
    public Object getState(Object key) {
        if (this.myStates == null) {
            return null;
        }
        return this.myStates.get(key);
    }

    @Override
    public Object removeState(Object key) {
        if (this.myStates == null) {
            return null;
        }
        return this.myStates.remove(key);
    }

    @Override
    public void putState(Object key, Object state) {
        if (this.myStates == null) {
            this.myStates = new HashMap();
        }
        this.myStates.put(key, state);
    }

    public void clearStates() {
        if (this.myStates != null) {
            this.myStates.clear();
        }
    }

    public EreManager getEreManager() {
        return this.myEreManager;
    }

    public void setEreManager(EreManager parEreManager) {
        this.myEreManager = parEreManager;
    }

    @Override
    public void addPeriodTreeDescritpion(PeriodTreeDescription periodTree) {
        periodTree.setServiceProvider(this.myCurrentServiceProvider);
        periodTree.setRatingPlan(this.getCurrentRatingPlanName());
        periodTree.setRatingPeriod(this.myCurrentRatingPeriod);
        this.myPeridTreeDescriptionList.add(periodTree);
    }

    @Override
    public List<PeriodTreeDescription> getPeriodTreeDescriptionList() {
        return this.myPeridTreeDescriptionList;
    }

    @Override
    public String getCurrentServiceProvider() {
        return this.myCurrentServiceProvider;
    }

    @Override
    public void setCurrentServiceProvider(String currentServiceProvider) {
        this.myCurrentServiceProvider = currentServiceProvider;
    }

    @Override
    public String getCurrentRatingPlanName() {
        return this.myCurrentRatingPlan != null ? this.myCurrentRatingPlan.getIdentity() : null;
    }

    @Override
    public RatingPlan getCurrentRatingPlan() {
        return this.myCurrentRatingPlan;
    }

    @Override
    public void setCurrentRatingPlan(RatingPlan currentRatingPlan) {
        this.myCurrentRatingPlan = currentRatingPlan;
    }

    @Override
    public String getCurrentRatingPeriod() {
        return this.myCurrentRatingPeriod;
    }

    @Override
    public void setCurrentRatingPeriod(String currentRatingPeriod) {
        this.myCurrentRatingPeriod = currentRatingPeriod;
    }

    public RangeStrategy getFieldOperationRangeStrategy() {
        return this.myFORangeStrategy;
    }

    public void setFieldOperationRangeStrategy(RangeStrategy strategy) {
        this.myFORangeStrategy = strategy;
    }

    public RangeStrategy getSetFieldRangeStrategy() {
        return this.mySFRangeStrategy;
    }

    public void setSetFieldRangeStrategy(RangeStrategy strategy) {
        this.mySFRangeStrategy = strategy;
    }

    @Override
    public List<SelectionTreeQualifier> getQualifierList() {
        return Collections.unmodifiableList(this.mySTQStack);
    }

    @Override
    public SelectionTreeQualifier popQualifier() {
        return this.mySTQStack.pop();
    }

    @Override
    public void pushQualifier(SelectionTreeQualifier qualifier) {
        this.mySTQStack.push(qualifier);
    }

    @Override
    public AmountFactory getAmountFactory() {
        return DefaultAmountFactory.getInstance();
    }

    @Override
    public final void setTreeExecutor(TreeExecutor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("The TreeExecutor must not be null.");
        }
        this.myTreeExecutor = executor;
    }

    @Override
    public final TreeExecutor getTreeExecutor() {
        return this.myTreeExecutor;
    }

    @Override
    public DataSetAccessor getAccessor() {
        if (this.myAccessor == null) {
            this.myAccessor = new DefaultDataSetAccessor(this);
        }
        return this.myAccessor;
    }

    @Override
    public void setAccessor(DataSetAccessor acc) {
        this.myAccessor = acc;
    }

    protected static class ValueComparator
    implements Comparator<Object> {
        protected ValueComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int ret;
            if (o1 instanceof EREDate) {
                ret = o2 instanceof EREDate ? ((EREDate)o1).compareTo((EREDate)o2) : (o2 instanceof Calendar ? ((EREDate)o1).compareTo((Calendar)o2) : (o2 instanceof Date ? ((EREDate)o1).compareTo((Date)o2) : 0));
            } else if (o1 instanceof Comparable) {
                try {
                    ret = ((Comparable)o1).compareTo(o2);
                }
                catch (Exception e) {
                    ret = 0;
                }
            } else {
                ret = 0;
            }
            return ret;
        }
    }
}

